/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.primitive.impl;

import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractBytes;
import com.pushtechnology.diffusion.datatype.internal.AbstractDataType;
import com.pushtechnology.diffusion.datatype.internal.SupplierFromBytes;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.impl.JSONImpl;
import com.pushtechnology.diffusion.datatype.mqtt.MQTTUTF8;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

abstract class PrimitiveDataTypeImpl<V>
extends AbstractDataType<V, ArrayIBytes> {
    private static final ArrayIBytes CBOR_NULL = ArrayIBytes.toArrayIBytes(new byte[]{-10});
    private final Encoder<V> encoder;

    protected PrimitiveDataTypeImpl(String typeName, Class<?> valueClass, Encoder<V> encoder, Decoder<V> decoder, SupplierFromBytes<MQTTUTF8> toMQTTUTF8, boolean withBinaryDelta) {
        super(typeName, valueClass, ArrayIBytes.class, ArrayIBytes::toArrayIBytes, PrimitiveDataTypeImpl.vToC(encoder), PrimitiveDataTypeImpl.cToV(decoder), PrimitiveDataTypeImpl.withMQTTAndJSONConverters(toMQTTUTF8), withBinaryDelta);
        this.encoder = encoder;
    }

    private static Map<Class<?>, SupplierFromBytes<?>> withMQTTAndJSONConverters(SupplierFromBytes<MQTTUTF8> toMQTTUTF8) {
        HashMap result = new HashMap();
        result.put(JSON.class, JSONImpl::new);
        result.put(MQTTUTF8.class, toMQTTUTF8);
        return result;
    }

    protected static final boolean isCBORNull(byte[] bs, int offset, int length) {
        return length == 1 && bs[offset] == -10;
    }

    @Override
    public final void writeValue(V value, OutputStream out) throws IOException {
        if (value == null) {
            CBOR_NULL.copyTo(out);
        } else {
            this.encoder.apply(out, value);
        }
    }

    @Override
    public final void validate(V value) {
    }

    @Override
    protected boolean isCompatible(Bytes bytes) {
        return !(bytes instanceof AbstractBytes) && super.isCompatible(bytes);
    }

    private static <V> Function<V, ArrayIBytes> vToC(Encoder<V> encoder) {
        return v -> {
            if (v == null) {
                return CBOR_NULL;
            }
            IBytesOutputStreamImpl out = PrimitiveDataTypeImpl.threadLocalIBytesOutputStream();
            try {
                encoder.apply(out, v);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            return ArrayIBytes.toArrayIBytes(((IBytesOutputStream)out).toIBytes());
        };
    }

    private static <V> Function<ArrayIBytes, V> cToV(Decoder<V> decoder) {
        return bytes -> {
            if (CBOR_NULL.equals(bytes)) {
                return null;
            }
            try {
                return decoder.apply(bytes.toByteArrayInternal());
            }
            catch (IOException e) {
                throw new InvalidDataException(e);
            }
        };
    }

    @FunctionalInterface
    protected static interface Encoder<T> {
        public void apply(OutputStream var1, T var2) throws IOException;
    }

    @FunctionalInterface
    protected static interface Decoder<T> {
        public T apply(byte[] var1) throws IOException;
    }
}

