/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.primitive.impl;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.mqtt.MQTTUTF8;
import com.pushtechnology.diffusion.datatype.primitive.impl.CborCodec;
import com.pushtechnology.diffusion.datatype.primitive.impl.PrimitiveDataTypeImpl;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.io.IOException;
import net.jcip.annotations.Immutable;

@Immutable
public final class DoubleDataTypeImpl
extends PrimitiveDataTypeImpl<Double> {
    public DoubleDataTypeImpl() {
        super("double", Double.class, CborCodec::encodeDouble, CborCodec::decodeDouble, DoubleDataTypeImpl::toMQTTUTF8, false);
    }

    private static MQTTUTF8 toMQTTUTF8(byte[] bs, int o, int l) {
        double v;
        if (DoubleDataTypeImpl.isCBORNull(bs, o, l)) {
            return null;
        }
        try {
            v = CborCodec.decodeDouble(bs, o, l);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        return new MQTTUTF8(CharsetUtils.stringToBytesUTF8(Double.toString(v)));
    }
}

