/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import com.pushtechnology.diffusion.datatype.internal.JacksonContext;
import com.pushtechnology.diffusion.datatype.json.impl.JSONImpl;
import com.pushtechnology.diffusion.datatype.json.impl.JSONPointer;
import com.pushtechnology.repackaged.jackson.core.JsonToken;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORParser;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORReadContext;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class SpanParser {
    private final CBORParser parser;
    private final JSONImpl json;
    private StructureAccumulator structure = new RootAccumulator();
    private final Deque<StructureAccumulator> parentStack = new ArrayDeque<StructureAccumulator>();
    private final int startOffset;

    SpanParser(JSONImpl json) {
        this.parser = JacksonContext.createCBORParser(json.bytes(), json.offset(), json.length());
        this.json = json;
        this.startOffset = (int)this.parser.currentLocation().getByteOffset();
    }

    public int spanTo(int offset, ResultConsumer result) throws IOException {
        return this.spanTo(offset, result, false);
    }

    public int spanToNext(int offset, ResultConsumer result) throws IOException {
        return this.spanTo(offset, result, true);
    }

    private int spanTo(int offset, ResultConsumer result, boolean atLeastOne) throws IOException {
        int start = this.nextByte();
        if (start >= offset) {
            return 0;
        }
        int lastHeight = this.parentStack.size();
        boolean consumeFirstValue = atLeastOne;
        int next = start;
        do {
            JsonToken t = this.parser.nextToken();
            this.parser.finishToken();
            int tokenStart = next;
            next = this.nextByte();
            if (t == null) {
                if (this.parentStack.isEmpty()) break;
                throw new IOException("Invalid structure");
            }
            if (t.isScalarValue()) {
                this.structure.add(next);
                consumeFirstValue = false;
                continue;
            }
            if (t == JsonToken.START_ARRAY) {
                this.parentStack.addLast(this.structure);
                this.structure = this.structure.newArray(tokenStart, next);
                continue;
            }
            if (t == JsonToken.START_OBJECT) {
                this.parentStack.addLast(this.structure);
                this.structure = this.structure.newObject(tokenStart, next);
                continue;
            }
            if (t.isStructEnd()) {
                StructureAccumulator parent = this.parentStack.removeLast();
                if (this.structure.notEmptyAndSplitBy(start)) {
                    this.structure.takeAll(result);
                    this.structure.splitStructureEnd(result);
                    parent.skip();
                    parent.setNextStart(next);
                } else {
                    parent.add(next);
                }
                this.structure = parent;
                consumeFirstValue = false;
                continue;
            }
            assert (t == JsonToken.FIELD_NAME);
            this.structure.setNextStart(next);
            consumeFirstValue = true;
        } while (consumeFirstValue || next < offset || this.nextTokenIsStructEnd(next));
        for (StructureAccumulator p : this.parentStack) {
            p.takeAll(result);
        }
        this.structure.takeAll(result);
        return this.parentStack.size() - lastHeight;
    }

    private boolean nextTokenIsStructEnd(int next) {
        CBORReadContext context = this.parser.getParsingContext();
        if (this.parser.currentToken().isStructStart()) {
            return context.getExpectedLength() == 0;
        }
        return context.acceptsBreakMarker() && next < this.json.length() && this.json.bytes()[this.json.offset() + next] == -1 || context.getEntryCount() == context.getExpectedLength();
    }

    public int nextByte() {
        return (int)this.parser.currentLocation().getByteOffset() - this.startOffset;
    }

    public String toString() {
        StringBuilder result = new StringBuilder((this.parentStack.size() + 1) * 20);
        result.append(this.getClass().getSimpleName());
        result.append(" next=").append(this.nextByte());
        result.append(" [");
        for (StructureAccumulator x : this.parentStack) {
            result.append(x).append(',');
        }
        result.append(this.structure);
        result.append(']');
        return result.toString();
    }

    private static long rangeToLong(int start, int end) {
        return (long)start + ((long)end << 32);
    }

    private final class RootAccumulator
    extends AbstractAccumulator {
        RootAccumulator() {
            super(JSONPointer.ROOT, -1, 0, false);
        }

        @Override
        protected void take(ResultConsumer result, JSONPointer base, int firstAccumulatedIndex, int index, int start, int length) throws IOException {
            if (this.total() > 1) {
                throw new IOException("Invalid JSON: multiple values found");
            }
            result.accept(base, start, length);
        }

        @Override
        public JSONPointer currentPointer(JSONPointer base, int total) {
            return base;
        }
    }

    private static interface StructureAccumulator {
        public void add(int var1) throws IOException;

        public void setNextStart(int var1);

        public void skip();

        public void takeAll(ResultConsumer var1) throws IOException;

        public boolean notEmptyAndSplitBy(int var1);

        public void splitStructureEnd(ResultConsumer var1);

        public StructureAccumulator newArray(int var1, int var2) throws IOException;

        public StructureAccumulator newObject(int var1, int var2) throws IOException;
    }

    public static interface ResultConsumer {
        public void accept(JSONPointer var1, int var2, int var3);

        public void splitStructureEnd(JSONPointer var1, int var2, int var3, int var4);
    }

    private final class ObjectAccumulator
    extends AbstractAccumulator {
        private String[] keys;

        ObjectAccumulator(JSONPointer pointer, int start, int next) {
            super(pointer, start, next, !SpanParser.this.parser.getParsingContext().hasExpectedLength());
        }

        @Override
        public void add(int tokenEnd) throws IOException {
            int c = this.accumulated();
            if (this.keys == null) {
                assert (c == 0);
                this.keys = new String[16];
            } else if (c == this.keys.length) {
                this.keys = Arrays.copyOfRange(this.keys, 0, c * 2);
            }
            this.keys[c] = SpanParser.this.parser.currentName();
            super.add(tokenEnd);
        }

        @Override
        protected void take(ResultConsumer result, JSONPointer base, int firstAccumulatedIndex, int index, int start, int length) {
            result.accept(base.withKey(this.keys[index - firstAccumulatedIndex]), start, length);
        }

        @Override
        public JSONPointer currentPointer(JSONPointer base, int total) throws IOException {
            return base.withKey(SpanParser.this.parser.currentName());
        }
    }

    private final class ArrayAccumulator
    extends AbstractAccumulator {
        ArrayAccumulator(JSONPointer pointer, int start, int next) {
            super(pointer, start, next, !SpanParser.this.parser.getParsingContext().hasExpectedLength());
        }

        @Override
        protected void take(ResultConsumer result, JSONPointer base, int firstAccumulatedIndex, int index, int start, int length) {
            result.accept(base.withIndex(index), start, length);
        }

        @Override
        public JSONPointer currentPointer(JSONPointer base, int total) {
            return base.withIndex(total);
        }
    }

    private abstract class AbstractAccumulator
    implements StructureAccumulator {
        private final JSONPointer base;
        private final int startOffset;
        private int accumulated = 0;
        private int total = 0;
        private long[] tokenRange;
        private int nextOffset;
        private final boolean expectBreak;

        protected AbstractAccumulator(JSONPointer base, int start, int next, boolean expectBreak) {
            this.base = base;
            this.startOffset = start;
            this.nextOffset = next;
            this.expectBreak = expectBreak;
        }

        @Override
        public final ArrayAccumulator newArray(int start, int next) throws IOException {
            return new ArrayAccumulator(this.currentPointer(this.base, this.total), start, next);
        }

        @Override
        public final ObjectAccumulator newObject(int start, int next) throws IOException {
            return new ObjectAccumulator(this.currentPointer(this.base, this.total), start, next);
        }

        @Override
        public final boolean notEmptyAndSplitBy(int byteOffset) {
            return this.startOffset < byteOffset && this.total != 0;
        }

        @Override
        public void add(int next) throws IOException {
            if (this.tokenRange == null) {
                this.tokenRange = new long[16];
            } else if (this.accumulated == this.tokenRange.length) {
                this.tokenRange = Arrays.copyOfRange(this.tokenRange, 0, this.accumulated * 2);
            }
            this.tokenRange[this.accumulated] = SpanParser.rangeToLong(this.nextOffset, next);
            this.nextOffset = next;
            ++this.accumulated;
            ++this.total;
        }

        @Override
        public final void setNextStart(int offset) {
            this.nextOffset = offset;
        }

        @Override
        public final void skip() {
            ++this.total;
            this.accumulated = 0;
        }

        @Override
        public final void takeAll(ResultConsumer result) throws IOException {
            int next = this.total;
            int begin = next - this.accumulated;
            for (int i = 0; i < this.accumulated; ++i) {
                long range = this.tokenRange[i];
                int rangeStart = (int)range;
                int rangeEnd = (int)(range >> 32);
                this.take(result, this.base, begin, begin + i, rangeStart, rangeEnd - rangeStart);
            }
            this.accumulated = 0;
        }

        protected abstract JSONPointer currentPointer(JSONPointer var1, int var2) throws IOException;

        protected abstract void take(ResultConsumer var1, JSONPointer var2, int var3, int var4, int var5, int var6) throws IOException;

        protected final int accumulated() {
            return this.accumulated;
        }

        protected final int total() {
            return this.total;
        }

        @Override
        public final void splitStructureEnd(ResultConsumer result) {
            int length = this.nextOffset - this.startOffset + (this.expectBreak ? 1 : 0);
            result.splitStructureEnd(this.base, this.total, this.startOffset, length);
        }

        public final String toString() {
            return this.base.toString();
        }
    }
}

