/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import com.pushtechnology.diffusion.datatype.BinaryDelta;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractBytes;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaType;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.datatype.internal.JacksonContext;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDelta;
import com.pushtechnology.diffusion.datatype.json.impl.JSONDeltaImpl;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.repackaged.jackson.core.JsonGenerator;
import com.pushtechnology.repackaged.jackson.core.JsonToken;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.jcip.annotations.Immutable;

@Immutable
public final class JSONImpl
extends AbstractBytes
implements JSON {
    private static final BinaryDeltaType<JSON, JSONImpl> BINARY_DELTA_TYPE = new BinaryDeltaType<JSON, JSONImpl>(JSONImpl::new, JSONImpl.class::cast, JSON.class::cast);

    public JSONImpl(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public InternalBinaryDelta binaryDiff(JSON original) {
        return BINARY_DELTA_TYPE.diff((Object)original, (Object)this);
    }

    @Override
    public JSONImpl apply(BinaryDelta delta) {
        return (JSONImpl)BINARY_DELTA_TYPE.apply((JSON)this, delta);
    }

    @Override
    public JSONDelta diff(JSON original) {
        InternalBinaryDelta binaryDiff = this.binaryDiff(original);
        return new JSONDeltaImpl((JSONImpl)original, this, binaryDiff);
    }

    @Override
    public String toJsonString() {
        return CharsetUtils.bytesUTF8ToString(JSONImpl.toJsonUTF8(this.bytes(), this.offset(), this.length()));
    }

    static byte[] toJsonUTF8(byte[] bs, int offset, int length) {
        ByteArrayOutputStream baos;
        CBORParser parser = JacksonContext.createCBORParser(bs, offset, length);
        try {
            if (parser.nextToken() == null) {
                throw new InvalidDataException("No CBOR data item found");
            }
            baos = new ByteArrayOutputStream(length * 2);
            JsonGenerator g = JacksonContext.createJsonGenerator(baos);
            g.copyCurrentStructure(parser);
            g.close();
            if (parser.nextToken() != null) {
                throw new InvalidDataException("CBOR contains more than one value");
            }
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        return baos.toByteArray();
    }

    @Override
    public JSON validate() {
        CBORParser parser = JacksonContext.createCBORParser(this.bytes(), this.offset(), this.length());
        try {
            if (parser.nextToken() == null) {
                throw new InvalidDataException("No CBOR data item found");
            }
            int rootTokens = 0;
            do {
                if (!parser.getParsingContext().inRoot()) continue;
                if (rootTokens > 0) {
                    throw new InvalidDataException("CBOR contains more than one value");
                }
                ++rootTokens;
            } while (parser.nextToken() != null);
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        if (!parser.getParsingContext().inRoot()) {
            throw new InvalidDataException("CBOR structure not closed");
        }
        return this;
    }

    @Override
    public String toString() {
        int maxTokenStart = 80;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(160);
        CBORParser parser = JacksonContext.createCBORParser(this.bytes(), this.offset(), this.length());
        try {
            JsonToken t;
            JsonGenerator g = JacksonContext.createJsonGeneratorForToString(baos);
            while ((t = parser.nextToken()) != null) {
                g.copyCurrentEvent(parser);
                if (parser.getCurrentLocation().getByteOffset() < 80L) continue;
            }
            g.close();
            return "JSON <" + this.length() + " bytes> " + CharsetUtils.bytesUTF8ToString(baos.toByteArray());
        }
        catch (IOException e) {
            return "Invalid JSON value <" + this.length() + " bytes>";
        }
    }
}

