/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDelta;
import com.pushtechnology.diffusion.datatype.json.impl.JSONImpl;
import com.pushtechnology.diffusion.datatype.json.impl.JSONPointer;
import com.pushtechnology.diffusion.datatype.json.impl.JSONPointerMap;
import com.pushtechnology.diffusion.datatype.json.impl.SpanParser;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
final class JSONDeltaImpl
implements JSONDelta {
    private final JSONPointerMap<JSON> removed = new JSONPointerMap();
    private final JSONPointerMap<JSON> inserted = new JSONPointerMap();

    JSONDeltaImpl(JSONImpl original, JSONImpl newValue, InternalBinaryDelta binaryDelta) {
        if (binaryDelta.hasChanges()) {
            DeltaVisitor visitor = new DeltaVisitor(original, newValue);
            BinaryDeltaParser parser = binaryDelta.createParser();
            while (parser.next(visitor::match, (bytes, offset, length) -> visitor.insert(length))) {
            }
            visitor.end();
            return;
        }
    }

    private static JSONImpl partOf(JSONImpl value, int start, int length) {
        return new JSONImpl(value.bytes(), value.offset() + start, length);
    }

    private static JSONImpl copyPartOf(JSONImpl value, int start, int length) {
        int offsetStart = value.offset() + start;
        byte[] bytes = Arrays.copyOfRange(value.bytes(), offsetStart, offsetStart + length);
        return new JSONImpl(bytes, 0, length);
    }

    private static boolean isPartOf(JSONImpl cbor, JSONImpl other, int start, int length) {
        return cbor.equalBytes(other.bytes(), other.offset() + start, length);
    }

    @Override
    public JSONDelta.ChangeMap removed() {
        return new ChangeMapImpl(this.removed);
    }

    @Override
    public JSONDelta.ChangeMap inserted() {
        return new ChangeMapImpl(this.inserted);
    }

    @Override
    public boolean hasChanges() {
        return this.removed.size() != 0 || this.inserted.size() != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder((this.removed.size() + this.inserted.size()) * 10);
        sb.append("REMOVE ");
        sb.append(this.removed);
        sb.append(" INSERT ");
        sb.append(this.inserted);
        return sb.toString();
    }

    @NotThreadSafe
    private final class DeltaVisitor {
        private final JSONImpl oldValue;
        private final JSONImpl newValue;
        private final SpanParser oldParser;
        private final SpanParser newParser;
        private final JSONPointerMap<SplitStructure> removedSplitStructures = new JSONPointerMap();
        private final JSONPointerMap<SplitStructure> insertedSplitStructures = new JSONPointerMap();
        private int oldOffset = 0;
        private int newOffset = 0;
        private JSONPointer pendingRemove = null;
        private JSONImpl pendingRemoveValue = null;
        private JSONPointer pendingInsert = null;
        private JSONImpl pendingInsertValue = null;
        private final SpanParser.ResultConsumer insert = new SpanParser.ResultConsumer(){

            @Override
            public void accept(JSONPointer jp, int start, int length) {
                if (DeltaVisitor.this.pendingRemove != null && DeltaVisitor.this.pendingRemove.equalIgnoringIndexes(jp) && JSONDeltaImpl.isPartOf(DeltaVisitor.this.pendingRemoveValue, DeltaVisitor.this.newValue, start, length)) {
                    DeltaVisitor.this.pendingRemove = null;
                    DeltaVisitor.this.pendingRemoveValue = null;
                } else {
                    DeltaVisitor.this.addInsert(jp, JSONDeltaImpl.partOf(DeltaVisitor.this.newValue, start, length));
                    DeltaVisitor.this.addRemove(null, null);
                }
            }

            @Override
            public void splitStructureEnd(JSONPointer pointer, int elementCount, int start, int length) {
                DeltaVisitor.this.insertedSplitStructures.put(pointer, new SplitStructure(elementCount, start, length));
            }
        };
        private final SpanParser.ResultConsumer remove = new SpanParser.ResultConsumer(){

            @Override
            public void accept(JSONPointer jp, int start, int length) {
                if (DeltaVisitor.this.pendingInsert != null && DeltaVisitor.this.pendingInsert.equalIgnoringIndexes(jp) && JSONDeltaImpl.isPartOf(DeltaVisitor.this.pendingInsertValue, DeltaVisitor.this.oldValue, start, length)) {
                    DeltaVisitor.this.pendingInsert = null;
                    DeltaVisitor.this.pendingInsertValue = null;
                } else {
                    DeltaVisitor.this.addRemove(jp, JSONDeltaImpl.copyPartOf(DeltaVisitor.this.oldValue, start, length));
                    DeltaVisitor.this.addInsert(null, null);
                }
            }

            @Override
            public void splitStructureEnd(JSONPointer pointer, int elementCount, int start, int length) {
                DeltaVisitor.this.removedSplitStructures.put(pointer, new SplitStructure(elementCount, start, length));
            }
        };

        private DeltaVisitor(JSONImpl oldValue, JSONImpl newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.oldParser = new SpanParser(oldValue);
            this.newParser = new SpanParser(newValue);
        }

        void match(int start, int length) {
            this.handleDelete(this.oldOffset, start - this.oldOffset);
            this.handleMatch(start, length);
        }

        private void handleDelete(int start, int length) {
            this.checkInvariants();
            int end = start + length;
            try {
                if (this.oldParser.nextByte() < end && (this.oldParser.spanTo(end, this.remove) != 0 || this.oldParser.nextByte() > end)) {
                    this.newParser.spanToNext(this.newOffset + 1, this.insert);
                }
            }
            catch (IOException e) {
                throw new InvalidDataException(e);
            }
        }

        private void handleMatch(int start, int length) {
            this.checkInvariants();
            int newStart = this.newOffset;
            int end = start + length;
            this.newOffset += length;
            this.oldOffset = end;
            int oldNextByte = this.oldParser.nextByte();
            int newNextByte = this.newParser.nextByte();
            try {
                boolean newSplit;
                if (newNextByte > newStart && oldNextByte == start) {
                    this.oldParser.spanToNext(start + 1, this.remove);
                } else if (oldNextByte > start && newNextByte == newStart) {
                    this.newParser.spanToNext(newStart + 1, this.insert);
                }
                LastResult lastOld = new LastResult(this.removedSplitStructures);
                LastResult lastNew = new LastResult(this.insertedSplitStructures);
                this.oldParser.spanTo(end, lastOld);
                this.newParser.spanTo(this.newOffset, lastNew);
                boolean oldSplit = lastOld.foundLast() && this.oldParser.nextByte() > end;
                boolean bl = newSplit = lastNew.foundLast() && this.newParser.nextByte() > this.newOffset;
                if (oldSplit && newSplit) {
                    lastOld.consumeLast(this.remove);
                    lastNew.consumeLast(this.insert);
                }
            }
            catch (IOException e) {
                throw new InvalidDataException(e);
            }
        }

        void insert(int length) {
            this.checkInvariants();
            this.newOffset += length;
            try {
                if (this.newParser.nextByte() < this.newOffset && (this.newParser.spanTo(this.newOffset, this.insert) != 0 || this.newParser.nextByte() > this.newOffset)) {
                    this.oldParser.spanToNext(this.oldOffset + 1, this.remove);
                }
            }
            catch (IOException e) {
                throw new InvalidDataException(e);
            }
        }

        void end() {
            this.handleDelete(this.oldOffset, this.oldValue.length() - this.oldOffset);
            this.addInsert(null, null);
            this.addRemove(null, null);
            this.replaceFullRemovedStructures();
            this.replaceFullInsertedStructures();
        }

        private void addInsert(JSONPointer nextPointer, JSONImpl nextValue) {
            if (this.pendingInsert != null) {
                JSONDeltaImpl.this.inserted.put(this.pendingInsert, this.pendingInsertValue);
            }
            this.pendingInsert = nextPointer;
            this.pendingInsertValue = nextValue;
        }

        private void addRemove(JSONPointer nextPointer, JSONImpl nextValue) {
            if (this.pendingRemove != null) {
                JSONDeltaImpl.this.removed.put(this.pendingRemove, this.pendingRemoveValue);
            }
            this.pendingRemove = nextPointer;
            this.pendingRemoveValue = nextValue;
        }

        private void checkInvariants() {
            if (this.oldParser.nextByte() < this.oldOffset) {
                throw new InvalidDataException("Invalid binary delta");
            }
            if (this.newParser.nextByte() < this.newOffset) {
                throw new InvalidDataException("Invalid binary delta");
            }
        }

        private void replaceFullRemovedStructures() {
            Iterator<JSONPointerMap.Entry> i = this.removedSplitStructures.postOrder();
            while (i.hasNext()) {
                JSONPointerMap.Entry s = i.next();
                SplitStructure split = (SplitStructure)s.getValue();
                JSONPointerMap.Entry entry = JSONDeltaImpl.this.removed.getEntry(s.getPointer());
                if (entry == null || entry.numberOfChildren() != split.elements) continue;
                entry.setValue(JSONDeltaImpl.copyPartOf(this.oldValue, split.start, split.length));
                entry.removeDescendants();
            }
        }

        private void replaceFullInsertedStructures() {
            Iterator<JSONPointerMap.Entry> i = this.insertedSplitStructures.postOrder();
            while (i.hasNext()) {
                JSONPointerMap.Entry s = i.next();
                SplitStructure split = (SplitStructure)s.getValue();
                JSONPointerMap.Entry entry = JSONDeltaImpl.this.inserted.getEntry(s.getPointer());
                if (entry == null || entry.numberOfChildren() != split.elements) continue;
                entry.setValue(JSONDeltaImpl.partOf(this.newValue, split.start, split.length));
                entry.removeDescendants();
            }
        }
    }

    @Immutable
    private static final class ChangeMapImpl
    extends AbstractMap<String, JSON>
    implements JSONDelta.ChangeMap {
        private final JSONPointerMap<JSON> parts;
        private final Set<Map.Entry<String, JSON>> entrySet = new ChangeSet();

        ChangeMapImpl(JSONPointerMap<JSON> parts) {
            this.parts = parts;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.parts.contains(JSONPointer.parse((String)key));
        }

        @Override
        public JSON get(Object key) {
            return this.parts.get(JSONPointer.parse((String)key));
        }

        @Override
        public Set<Map.Entry<String, JSON>> entrySet() {
            return this.entrySet;
        }

        @Override
        public JSONDelta.ChangeMap descendants(String pointer) {
            return new ChangeMapImpl(this.parts.descendants(JSONPointer.parse(pointer)));
        }

        @Override
        public JSONDelta.ChangeMap intersection(String pointer) {
            return new ChangeMapImpl(this.parts.intersection(JSONPointer.parse(pointer)));
        }

        private final class ChangeSet
        extends AbstractSet<Map.Entry<String, JSON>> {
            private ChangeSet() {
            }

            @Override
            public Iterator<Map.Entry<String, JSON>> iterator() {
                final Iterator<JSONPointerMap.Entry> i = ChangeMapImpl.this.parts.iterator();
                return new Iterator<Map.Entry<String, JSON>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, JSON> next() {
                        return new ChangeMapEntry((JSONPointerMap.Entry)i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ChangeMapImpl.this.parts.size();
            }
        }
    }

    private static final class ChangeMapEntry
    implements Map.Entry<String, JSON> {
        private final JSONPointerMap.Entry n;

        private ChangeMapEntry(JSONPointerMap.Entry n) {
            this.n = n;
        }

        @Override
        public String getKey() {
            return this.n.getPointer().toString();
        }

        @Override
        public JSON getValue() {
            return (JSON)this.n.getValue();
        }

        @Override
        public JSON setValue(JSON value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeMapEntry)) {
                return false;
            }
            return this.n.equals(((ChangeMapEntry)o).n);
        }

        @Override
        public int hashCode() {
            return this.n.hashCode();
        }

        public String toString() {
            return this.n.toString();
        }
    }

    @Immutable
    private static final class SplitStructure {
        private final int elements;
        private final int start;
        private final int length;

        SplitStructure(int elements, int start, int length) {
            this.elements = elements;
            this.start = start;
            this.length = length;
        }
    }

    @NotThreadSafe
    private static final class LastResult
    implements SpanParser.ResultConsumer {
        private final JSONPointerMap<SplitStructure> splitStructures;
        private JSONPointer last;
        private int lastStart;
        private int lastLength;

        LastResult(JSONPointerMap<SplitStructure> splitStructures) {
            this.splitStructures = splitStructures;
        }

        @Override
        public void accept(JSONPointer jp, int start, int length) {
            this.last = jp;
            this.lastStart = start;
            this.lastLength = length;
        }

        boolean foundLast() {
            return this.last != null;
        }

        void consumeLast(SpanParser.ResultConsumer delegate) {
            assert (this.last != null);
            delegate.accept(this.last, this.lastStart, this.lastLength);
        }

        @Override
        public void splitStructureEnd(JSONPointer pointer, int elementCount, int start, int length) {
            this.splitStructures.put(pointer, new SplitStructure(elementCount, start, length));
        }
    }
}

