/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.json.impl;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractDataType;
import com.pushtechnology.diffusion.datatype.internal.JacksonContext;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import com.pushtechnology.diffusion.datatype.json.impl.JSONImpl;
import com.pushtechnology.diffusion.datatype.mqtt.MQTTUTF8;
import com.pushtechnology.repackaged.jackson.core.JsonGenerator;
import com.pushtechnology.repackaged.jackson.core.JsonParser;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import net.jcip.annotations.Immutable;

@Immutable
public final class JSONDataTypeImpl
extends AbstractDataType<JSON, JSONImpl>
implements JSONDataType {
    public JSONDataTypeImpl() {
        super("json", JSON.class, JSONImpl.class, JSONImpl::new, JSONImpl.class::cast, JSON.class::cast, Collections.singletonMap(MQTTUTF8.class, JSONDataTypeImpl::toMQTTUTF8), true);
    }

    private static MQTTUTF8 toMQTTUTF8(byte[] bs, int o, int l) {
        return new MQTTUTF8(JSONImpl.toJsonUTF8(bs, o, l));
    }

    @Override
    public JSON fromJsonString(String json) {
        ByteArrayOutputStream baos;
        try {
            JsonParser parser = JacksonContext.JSON_FACTORY.createParser(json);
            if (parser.nextToken() == null) {
                throw new InvalidDataException("No JSON value found");
            }
            baos = new ByteArrayOutputStream(json.length());
            CBORGenerator g = JacksonContext.createCborGenerator(baos);
            g.copyCurrentStructure(parser);
            ((JsonGenerator)g).close();
            if (parser.nextToken() != null) {
                throw new InvalidDataException("Input contains more than one value");
            }
        }
        catch (IOException e) {
            throw new InvalidDataException(e);
        }
        return (JSON)this.readValue(baos.toByteArray());
    }

    @Override
    public void validate(JSON value) {
        value.validate();
    }
}

