/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.repackaged.jackson.core.JsonFactory;
import com.pushtechnology.repackaged.jackson.core.JsonGenerator;
import com.pushtechnology.repackaged.jackson.core.StreamReadFeature;
import com.pushtechnology.repackaged.jackson.core.StreamWriteFeature;
import com.pushtechnology.repackaged.jackson.core.TSFBuilder;
import com.pushtechnology.repackaged.jackson.core.json.JsonWriteFeature;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORFactory;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORFactoryBuilder;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORGenerator;
import com.pushtechnology.repackaged.jackson.dataformat.cbor.CBORParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class JacksonContext {
    public static final CBORFactory CBOR_FACTORY = ((CBORFactoryBuilder)((CBORFactoryBuilder)CBORFactory.builder().disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)).build();
    public static final JsonFactory JSON_FACTORY = ((TSFBuilder)((TSFBuilder)JsonFactory.builder().enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)).disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).build();
    private static final JsonFactory JSON_FACTORY_2 = ((TSFBuilder)((TSFBuilder)((TSFBuilder)((TSFBuilder)JsonFactory.builder().enable(StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION)).disable(JsonFactory.Feature.INTERN_FIELD_NAMES)).disable(JsonWriteFeature.QUOTE_FIELD_NAMES)).disable(StreamWriteFeature.AUTO_CLOSE_CONTENT)).build();

    private JacksonContext() {
    }

    public static CBORParser createCBORParser(byte[] bytes, int offset, int length) {
        try {
            return CBOR_FACTORY.createParser(bytes, offset, length);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CBORParser createCBORParser(InputStream stream) throws IOException {
        return CBOR_FACTORY.createParser(stream);
    }

    public static JsonGenerator createJsonGenerator(OutputStream out) {
        return JacksonContext.createGenerator(JSON_FACTORY, out);
    }

    public static JsonGenerator createJsonGeneratorForToString(OutputStream out) {
        return JacksonContext.createGenerator(JSON_FACTORY_2, out);
    }

    public static CBORGenerator createCborGenerator(OutputStream out) {
        return (CBORGenerator)JacksonContext.createGenerator(CBOR_FACTORY, out);
    }

    private static JsonGenerator createGenerator(JsonFactory factory, OutputStream out) {
        try {
            return factory.createGenerator(out).disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

