/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaImpl;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaSerialiser;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltas;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import java.util.Arrays;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class BinaryDeltaParserCompressor {
    private static FastThreadLocal<BinaryDeltaParserCompressor> compressors = FastThreadLocal.withInitial(BinaryDeltaParserCompressor::new);
    private final IBytesOutputStream result = new IBytesOutputStreamImpl();
    private int matchStart = -1;
    private int matchLength;
    private final Inserts inserts = new Inserts();

    BinaryDeltaParserCompressor() {
    }

    static BinaryDeltaImpl compress(BinaryDeltaParser parser) {
        if (parser == BinaryDeltaParser.NO_CHANGE_PARSER) {
            return (BinaryDeltaImpl)BinaryDeltas.NO_CHANGE;
        }
        BinaryDeltaParserCompressor compressor = compressors.get();
        compressor.reset();
        while (parser.next(compressor::onMatch, compressor::onInsert)) {
        }
        return compressor.close();
    }

    private void reset() {
        this.result.reset();
        this.inserts.reset();
        this.matchStart = -1;
    }

    private void onMatch(int start, int length) {
        if (this.inserts.hasData()) {
            this.inserts.flush(this.result);
        } else if (this.matchStart >= 0) {
            if (this.matchStart + this.matchLength == start) {
                this.matchLength += length;
                return;
            }
            this.writeMatch();
        }
        this.matchStart = start;
        this.matchLength = length;
    }

    private void onInsert(byte[] bytes, int offset, int length) {
        if (this.matchStart >= 0) {
            this.writeMatch();
            this.matchStart = -1;
        }
        this.inserts.push(bytes, offset, length);
    }

    private BinaryDeltaImpl close() {
        if (this.matchStart >= 0) {
            this.writeMatch();
        } else if (this.inserts.hasData()) {
            this.inserts.flush(this.result);
        }
        byte[] serialised = this.result.toByteArray();
        return new BinaryDeltaImpl(serialised, 0, serialised.length);
    }

    private void writeMatch() {
        BinaryDeltaSerialiser.writeMatch(this.result, this.matchStart, this.matchLength);
    }

    private static final class Inserts {
        private byte[][] buffers = new byte[8][];
        private long[] offsetsAndLengths = new long[8];
        private int numberOfBuffers;
        private int totalLength;

        private Inserts() {
        }

        void push(byte[] buffer, int offset, int length) {
            if (this.numberOfBuffers == this.buffers.length) {
                this.grow();
            }
            this.buffers[this.numberOfBuffers] = buffer;
            this.offsetsAndLengths[this.numberOfBuffers] = ((long)offset << 32) + (long)length;
            this.totalLength += length;
            ++this.numberOfBuffers;
        }

        public void reset() {
            this.numberOfBuffers = 0;
            this.totalLength = 0;
        }

        public boolean hasData() {
            return this.numberOfBuffers > 0;
        }

        private void grow() {
            int newLength = this.buffers.length << 1;
            this.buffers = (byte[][])Arrays.copyOf(this.buffers, newLength);
            this.offsetsAndLengths = Arrays.copyOf(this.offsetsAndLengths, newLength);
        }

        void flush(IBytesOutputStream result) {
            BinaryDeltaSerialiser.writeInsertLength(result, this.totalLength);
            for (int i = 0; i < this.numberOfBuffers; ++i) {
                long offsetAndLength = this.offsetsAndLengths[i];
                int offset = (int)(offsetAndLength >> 32);
                int length = (int)offsetAndLength;
                BinaryDeltaSerialiser.writeInsertBytes(result, this.buffers[i], offset, length);
            }
            this.reset();
        }
    }
}

