/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.AbstractDataType;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaParser;
import com.pushtechnology.diffusion.datatype.internal.InternalBinaryDelta;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.bytes.PartialArrayIBytes;
import com.pushtechnology.diffusion.utils.string.StringUtils;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;

@Immutable
final class BinaryDeltaImpl
extends PartialArrayIBytes
implements InternalBinaryDelta {
    BinaryDeltaImpl(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public boolean hasChanges() {
        return this.length() != 1 || this.toByteArrayInternal()[0] != -10;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(40 + this.length());
        sb.append("Binary Delta <");
        sb.append(Integer.toString(this.length()));
        sb.append(" bytes> ");
        if (!this.hasChanges()) {
            sb.append("NO CHANGE");
        } else {
            int maxInsertBytesLength = 20;
            int lengthBudget = 225;
            BinaryDeltaParser parser = this.createParser();
            try {
                while (parser.next((start, length) -> sb.append('[').append(start).append(',').append(length).append(']'), (bytes, offset, length) -> {
                    sb.append('|');
                    if (length < 20) {
                        StringUtils.appendHex(sb, bytes, offset, length);
                        sb.append('|');
                    } else {
                        StringUtils.appendHex(sb, bytes, offset, 20);
                        sb.append("...|");
                    }
                })) {
                    if (sb.length() <= 225) continue;
                    sb.append("...");
                    break;
                }
            }
            catch (InvalidDataException e) {
                return "Invalid Binary Delta <" + this.length() + " bytes>";
            }
        }
        return sb.toString();
    }

    @Override
    public IBytes apply(ArrayIBytes oldValue) {
        if (!this.hasChanges()) {
            return oldValue;
        }
        return new ParserImpl().apply(oldValue);
    }

    @Override
    public BinaryDeltaImpl toIBytes() {
        return this;
    }

    @Override
    public BinaryDeltaParser createParser() {
        if (!this.hasChanges()) {
            return BinaryDeltaParser.NO_CHANGE_PARSER;
        }
        return new ParserImpl();
    }

    @NotThreadSafe
    private final class ParserImpl
    implements BinaryDeltaParser {
        private final int end;
        private int p;
        private int lastMatchEnd;
        private int lastType;

        private ParserImpl() {
            this.end = BinaryDeltaImpl.this.offset() + BinaryDeltaImpl.this.length();
            this.p = BinaryDeltaImpl.this.offset();
            this.lastMatchEnd = -1;
            this.lastType = 0;
        }

        @Override
        public boolean next(BinaryDeltaParser.MatchConsumer onMatch, BinaryDeltaParser.InsertConsumer onInsert) throws InvalidDataException {
            if (this.p >= this.end) {
                return false;
            }
            byte ch = BinaryDeltaImpl.this.bytes()[this.p];
            int type = ch >> 5 & 7;
            if (type == 0) {
                int matchStart = this.readMatchStart();
                int matchLength = this.readMatchEnd(matchStart);
                onMatch.accept(matchStart, matchLength);
            } else if (type == 2) {
                int bytesLength = this.readInsertLength();
                onInsert.accept(BinaryDeltaImpl.this.bytes(), this.p, bytesLength);
                this.p += bytesLength;
            } else {
                throw new InvalidDataException("Unrecognized first byte: " + ch);
            }
            this.lastType = type;
            return true;
        }

        private int readMatchStart() {
            int matchStart = this.readUint();
            if (this.lastType == 0 && matchStart == this.lastMatchEnd) {
                throw new InvalidDataException("Adjacent matches");
            }
            if (matchStart < this.lastMatchEnd) {
                throw new InvalidDataException("Corrupt match sequence");
            }
            return matchStart;
        }

        private int readMatchEnd(int matchStart) {
            int matchLength = this.readUint();
            if (matchLength == 0) {
                throw new InvalidDataException("Zero match length");
            }
            this.lastMatchEnd = matchStart + matchLength;
            return matchLength;
        }

        private int readInsertLength() {
            int bytesLength = this.readUint();
            if (bytesLength == 0) {
                throw new InvalidDataException("Zero insert length");
            }
            if (this.p + bytesLength > this.end) {
                throw new InvalidDataException("Incomplete byte array");
            }
            return bytesLength;
        }

        private int readUint() throws InvalidDataException {
            byte[] bytes = BinaryDeltaImpl.this.bytes();
            try {
                int result;
                byte ch = bytes[this.p];
                int lowBits = ch & 0x1F;
                if (lowBits < 24) {
                    ++this.p;
                    result = lowBits;
                } else if (lowBits == 24) {
                    result = bytes[this.p + 1] & 0xFF;
                    this.p += 2;
                } else if (lowBits == 25) {
                    result = ((bytes[this.p + 1] & 0xFF) << 8) + (bytes[this.p + 2] & 0xFF);
                    this.p += 3;
                } else if (lowBits == 26) {
                    result = ((bytes[this.p + 1] & 0xFF) << 24) + ((bytes[this.p + 2] & 0xFF) << 16) + ((bytes[this.p + 3] & 0xFF) << 8) + (bytes[this.p + 4] & 0xFF);
                    this.p += 5;
                } else {
                    throw new InvalidDataException("Unrecognized first byte: " + ch);
                }
                return result;
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidDataException("Incomplete uint");
            }
        }

        @Override
        public Object mark() {
            return new Mark(this.p, this.lastMatchEnd, this.lastType);
        }

        @Override
        public void reset(Object m) {
            Mark mi = (Mark)m;
            this.p = mi.p;
            this.lastMatchEnd = mi.lastMatchEnd;
            this.lastType = mi.lastType;
        }

        IBytes apply(ArrayIBytes oldValue) throws InvalidDataException {
            IBytesOutputStreamImpl out = AbstractDataType.threadLocalIBytesOutputStream();
            while (this.p < this.end) {
                byte ch = BinaryDeltaImpl.this.bytes()[this.p];
                int type = ch >> 5 & 7;
                if (type == 0) {
                    int matchStart = this.readMatchStart();
                    int matchEnd = this.readMatchEnd(matchStart);
                    this.copyRange(oldValue, matchStart, matchEnd, out);
                } else if (type == 2) {
                    int bytesLength = this.readInsertLength();
                    ((IBytesOutputStream)out).write(BinaryDeltaImpl.this.bytes(), this.p, bytesLength);
                    this.p += bytesLength;
                } else {
                    throw new InvalidDataException("Unrecognized first byte: " + ch);
                }
                this.lastType = type;
            }
            return ((IBytesOutputStream)out).toIBytes();
        }

        private void copyRange(ArrayIBytes value, int start, int length, IBytesOutputStream out) {
            try {
                out.write(value.bytes(), value.offset() + start, length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new InvalidDataException(e);
            }
        }
    }

    @Immutable
    private static final class Mark {
        private final int p;
        private final int lastMatchEnd;
        private final int lastType;

        Mark(int p, int lastMatchEnd, int lastType) {
            this.p = p;
            this.lastMatchEnd = lastMatchEnd;
            this.lastType = lastType;
        }
    }
}

