/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.internal;

import com.pushtechnology.diffusion.datatype.BinaryDelta;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DeltaType;
import com.pushtechnology.diffusion.datatype.InvalidDataException;
import com.pushtechnology.diffusion.datatype.internal.BinaryDeltaType;
import com.pushtechnology.diffusion.datatype.internal.SupplierFromBytes;
import com.pushtechnology.diffusion.io.bytes.ArrayIBytes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public abstract class AbstractDataType<V, C extends ArrayIBytes>
implements DataType<V> {
    private static final FastThreadLocal<IBytesOutputStreamImpl> THREAD_LOCAL_OUTPUT_STREAM = FastThreadLocal.withInitial(IBytesOutputStreamImpl::new);
    private final String typeName;
    private final Class<C> implementationClass;
    private final Class<?> valueClass;
    private final BinaryDeltaType<V, C> binaryDeltaType;
    private final DeltaType<Bytes, BinaryDelta> serializedBinaryDeltaType;
    private final SupplierFromBytes<C> implementationFactory;
    private final Function<V, C> vToC;
    private final Function<C, V> cToV;
    private final Map<Class<?>, SupplierFromBytes<?>> valueConverters = new HashMap();

    protected static final IBytesOutputStreamImpl threadLocalIBytesOutputStream() {
        IBytesOutputStreamImpl result = THREAD_LOCAL_OUTPUT_STREAM.get();
        result.reset();
        return result;
    }

    protected AbstractDataType(String typeName, Class<?> valueClass, Class<C> implementationClass, SupplierFromBytes<C> implementationFactory, Function<V, C> vToC, Function<C, V> cToV, Map<Class<?>, SupplierFromBytes<?>> extraValueConverters, boolean withBinaryDelta) {
        this.typeName = typeName;
        this.valueClass = valueClass;
        this.implementationClass = implementationClass;
        this.implementationFactory = implementationFactory;
        this.vToC = vToC;
        this.cToV = cToV;
        if (withBinaryDelta) {
            this.binaryDeltaType = new BinaryDeltaType<V, C>(implementationFactory, vToC, cToV);
            this.serializedBinaryDeltaType = new BinaryDeltaType<Bytes, ArrayIBytes>("serialized binary", implementationFactory, x -> ArrayIBytes.toArrayIBytes(IBytes.toIBytes(x)), Bytes.class::cast);
        } else {
            this.binaryDeltaType = null;
            this.serializedBinaryDeltaType = null;
        }
        this.valueConverters.putAll(extraValueConverters);
        AbstractDataType.putIfAbsent(this.valueConverters, Bytes.class, implementationFactory);
        AbstractDataType.putIfAbsent(this.valueConverters, IBytes.class, implementationFactory);
    }

    private static <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        if (map.put(key, value) != null) {
            throw new IllegalArgumentException("Invalid extra value converter: " + String.valueOf(key));
        }
    }

    @Override
    public final String getTypeName() {
        return this.typeName;
    }

    @Override
    public void writeValue(V value, OutputStream out) throws IOException {
        this.toBytes((Object)value).copyTo(out);
    }

    @Override
    public final ArrayIBytes toBytes(V value) throws IllegalArgumentException {
        ArrayIBytes bytes = (ArrayIBytes)this.vToC.apply(value);
        if (bytes == null) {
            throw new IllegalArgumentException(String.valueOf(this) + " cannot convert value to Bytes: " + String.valueOf(value));
        }
        return bytes;
    }

    @Override
    public final V readValue(byte[] in, int offset, int length) {
        return this.cToV.apply((ArrayIBytes)this.implementationFactory.get(in, offset, length));
    }

    @Override
    public final V readValue(Bytes bytes) throws InvalidDataException {
        if (bytes.getClass().equals(this.implementationClass)) {
            return this.cToV.apply((ArrayIBytes)this.implementationClass.cast(bytes));
        }
        return this.readValue(IBytes.toByteArray(bytes));
    }

    @Override
    public final V readValue(byte[] bytes) throws InvalidDataException {
        return this.readValue(bytes, 0, bytes.length);
    }

    @Override
    public final DeltaType<V, ?> deltaType(String name) {
        DeltaType bdt = this.binaryDeltaType();
        if (bdt != null && name.equals(((BinaryDeltaType)bdt).getName())) {
            return bdt;
        }
        throw new IllegalArgumentException(String.valueOf(this) + " has no '" + name + "' delta type");
    }

    @Override
    public final <D> DeltaType<V, D> deltaType(Class<D> deltaClass) {
        DeltaType bdt;
        if (BinaryDelta.class.isAssignableFrom(deltaClass) && (bdt = this.binaryDeltaType()) != null) {
            return bdt;
        }
        throw new IllegalArgumentException(String.valueOf(this) + " has no delta type for " + String.valueOf(deltaClass));
    }

    @Override
    public final BinaryDeltaType<V, C> binaryDeltaType() {
        return this.binaryDeltaType;
    }

    @Override
    public DeltaType<Bytes, BinaryDelta> serializedBinaryDeltaType() {
        return this.serializedBinaryDeltaType;
    }

    @Override
    public final <T> T readAs(Class<T> classOfT, byte[] bytes, int offset, int length) throws InvalidDataException, IllegalArgumentException, IndexOutOfBoundsException {
        if (classOfT.isAssignableFrom(this.valueClass)) {
            return classOfT.cast(this.readValue(bytes, offset, length));
        }
        SupplierFromBytes<?> converter = this.valueConverters.get(classOfT);
        if (converter != null) {
            return classOfT.cast(converter.get(bytes, offset, length));
        }
        throw new IllegalArgumentException(String.valueOf(this) + " is incompatible with values of " + String.valueOf(classOfT));
    }

    @Override
    public final <T> T readAs(Class<T> classOfT, byte[] bytes) throws InvalidDataException, IllegalArgumentException {
        return this.readAs(classOfT, bytes, 0, bytes.length);
    }

    @Override
    public final <T> T readAs(Class<T> classOfT, Bytes bytes) throws InvalidDataException, IllegalArgumentException {
        if (this.isCompatible(bytes) && (classOfT != Object.class || this.valueClass.isAssignableFrom(this.implementationClass)) && classOfT.isInstance(bytes)) {
            return classOfT.cast(bytes);
        }
        return this.readAs(classOfT, IBytes.toByteArray(bytes));
    }

    protected boolean isCompatible(Bytes bytes) {
        return this.implementationClass.isInstance(bytes);
    }

    @Override
    public final <T> boolean canReadAs(Class<T> otherValueClass) {
        return otherValueClass.isAssignableFrom(this.valueClass) || this.valueConverters.containsKey(otherValueClass);
    }

    protected static final int cborIntegerCost(long i) {
        if (i == Long.MIN_VALUE) {
            return 9;
        }
        long a = Math.abs(i);
        if (a < 24L) {
            return 1;
        }
        if (a <= 255L) {
            return 2;
        }
        if (a <= 65535L) {
            return 3;
        }
        if (a <= 0xFFFFFFFFL) {
            return 5;
        }
        return 9;
    }

    @Override
    public void validate(Bytes bytes) throws InvalidDataException {
        this.validate(this.readValue(bytes));
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof DataType && this.typeName.equals(((DataType)o).getTypeName());
    }

    public final String toString() {
        return this.getTypeName() + " data type";
    }
}

