/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.impl;

import com.pushtechnology.diffusion.client.topics.details.TopicType;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.datatype.binary.Binary;
import com.pushtechnology.diffusion.datatype.binary.BinaryDataType;
import com.pushtechnology.diffusion.datatype.binary.impl.BinaryDataTypeImpl;
import com.pushtechnology.diffusion.datatype.json.JSON;
import com.pushtechnology.diffusion.datatype.json.JSONDataType;
import com.pushtechnology.diffusion.datatype.json.impl.JSONDataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.DoubleDataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.Int64DataTypeImpl;
import com.pushtechnology.diffusion.datatype.primitive.impl.StringDataTypeImpl;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2;
import com.pushtechnology.diffusion.datatype.recordv2.RecordV2DataType;
import com.pushtechnology.diffusion.datatype.recordv2.impl.RecordV2DataTypeImpl;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class DataTypesImpl
implements DataTypes {
    private static final List<Class> VALID_DATA_TYPES = new ArrayList<Class>();
    private final BinaryDataType binary = new BinaryDataTypeImpl();
    private final JSONDataType json = new JSONDataTypeImpl();
    private final RecordV2DataType recordV2 = new RecordV2DataTypeImpl();
    private final DataType<Double> doubleFloat = new DoubleDataTypeImpl();
    private final DataType<Long> int64 = new Int64DataTypeImpl();
    private final DataType<String> string = new StringDataTypeImpl();

    @Override
    public JSONDataType json() {
        return this.json;
    }

    @Override
    public BinaryDataType binary() {
        return this.binary;
    }

    @Override
    public RecordV2DataType recordV2() {
        return this.recordV2;
    }

    @Override
    public DataType<Double> doubleFloat() {
        return this.doubleFloat;
    }

    @Override
    public DataType<Long> int64() {
        return this.int64;
    }

    @Override
    public DataType<String> string() {
        return this.string;
    }

    @Override
    public DataType<?> getByName(String typeName) {
        switch (typeName) {
            case "json": {
                return this.json;
            }
            case "string": {
                return this.string;
            }
            case "binary": {
                return this.binary;
            }
            case "int64": {
                return this.int64;
            }
            case "double": {
                return this.doubleFloat;
            }
            case "record_v2": {
                return this.recordV2;
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + typeName);
    }

    @Override
    public <V> DataType<V> getByClass(Class<V> valueType) {
        if (JSON.class.isAssignableFrom(valueType)) {
            return this.json;
        }
        if (String.class.isAssignableFrom(valueType)) {
            return this.string;
        }
        if (Binary.class.isAssignableFrom(valueType)) {
            return this.binary;
        }
        if (Long.class.isAssignableFrom(valueType)) {
            return this.int64;
        }
        if (Double.class.isAssignableFrom(valueType)) {
            return this.doubleFloat;
        }
        if (RecordV2.class.isAssignableFrom(valueType)) {
            return this.recordV2;
        }
        if (valueType == Bytes.class) {
            return this.binary;
        }
        throw new IllegalArgumentException("No data type for " + String.valueOf(valueType));
    }

    @Override
    public void validateValueClass(Class<?> valueClass) {
        for (Class validClass : VALID_DATA_TYPES) {
            if (!valueClass.isAssignableFrom(validClass)) continue;
            return;
        }
        throw new IllegalArgumentException(String.valueOf(valueClass) + " is not a valid Datatype or a superclass of one.");
    }

    public static TopicType toTopicType(DataType<?> dataType) {
        return DataTypesImpl.toTopicType(dataType.getTypeName());
    }

    public static TopicType toTopicType(String typeName) {
        switch (typeName) {
            case "binary": {
                return TopicType.BINARY;
            }
            case "double": {
                return TopicType.DOUBLE;
            }
            case "int64": {
                return TopicType.INT64;
            }
            case "json": {
                return TopicType.JSON;
            }
            case "record_v2": {
                return TopicType.RECORD_V2;
            }
            case "string": {
                return TopicType.STRING;
            }
        }
        return TopicType.UNKNOWN_TOPIC_TYPE;
    }

    static {
        VALID_DATA_TYPES.add(JSON.class);
        VALID_DATA_TYPES.add(String.class);
        VALID_DATA_TYPES.add(Binary.class);
        VALID_DATA_TYPES.add(Long.class);
        VALID_DATA_TYPES.add(Double.class);
        VALID_DATA_TYPES.add(Bytes.class);
        VALID_DATA_TYPES.add(RecordV2.class);
    }
}

