/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.diff;

import com.pushtechnology.diffusion.datatype.diff.ActivityHistory;
import com.pushtechnology.diffusion.datatype.diff.BinaryDiff;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import com.pushtechnology.diffusion.utils.math.DiffusionMath;
import java.util.Arrays;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;

@NotThreadSafe
public final class MyersBinaryDiff
implements BinaryDiff {
    private static final Logger LOG = I18nLogger.getLogger(MyersBinaryDiff.class);
    private static final int INITIAL_LIMIT = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.initialLimit", ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.bailoutfactor", 10000));
    private static final int THRESHOLD_1 = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.utilization_threshold_1", 128);
    private static final int THRESHOLD_2 = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.utilization_threshold_2", 166);
    private static final int THRESHOLD_3 = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.utilization_threshold_3", 204);
    private static final int THRESHOLD_4 = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.utilization_threshold_4", 243);
    private static final int MINOR_QUALITY_CHANGE_REPORT_THRESHOLD = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.minor_quality_change_report_threshold", 5);
    private static final int QUALITY_DEGRADATION_SIZE = ConfigurationUtils.getIntegerSystemProperty("diffusion.binarydiff.utilization_input_size", 1024);
    private static final FastThreadLocal<MyersBinaryDiff> THREAD_LOCAL = FastThreadLocal.withInitial(MyersBinaryDiff::new);
    private final ActivityHistory history = new ActivityHistory(16, 1024L);
    private final Storage storage;
    private final int initialLimit;
    private Quality lastReportedQuality = Quality.HIGHEST;
    private int suppressedQualityReports = 0;
    private final long qualityDegradationThreshold;

    public static MyersBinaryDiff threadLocal() {
        return THREAD_LOCAL.get();
    }

    MyersBinaryDiff() {
        this(Integer.MAX_VALUE, INITIAL_LIMIT, QUALITY_DEGRADATION_SIZE * QUALITY_DEGRADATION_SIZE);
    }

    public MyersBinaryDiff(int maximumStorage, int initialLimit, long qualityDegradationThreshold) {
        this.storage = new Storage(maximumStorage);
        this.initialLimit = initialLimit;
        this.qualityDegradationThreshold = qualityDegradationThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryDiff.Result diff(byte[] a, int aoff, int n, byte[] b, int boff, int m, BinaryDiff.EditScript script) {
        if ((long)n * (long)m < this.qualityDegradationThreshold) {
            return this.diff(a, aoff, n, b, boff, m, script, Quality.HIGHEST);
        }
        this.history.start();
        try {
            int utilisation = this.history.utilisation();
            Quality quality = MyersBinaryDiff.qualityForUtilisation(utilisation);
            this.reportQualityChanges(utilisation, quality);
            BinaryDiff.Result result = this.diff(a, aoff, n, b, boff, m, script, quality);
            return result;
        }
        finally {
            this.history.stop();
        }
    }

    private void reportQualityChanges(int utilisation, Quality quality) {
        if (LOG.isInfoEnabled()) {
            int qualityDifference = quality.ordinal() - this.lastReportedQuality.ordinal();
            if (qualityDifference == 0) {
                return;
            }
            if (qualityDifference == 1 || qualityDifference == -1) {
                ++this.suppressedQualityReports;
                if (this.suppressedQualityReports < MINOR_QUALITY_CHANGE_REPORT_THRESHOLD) {
                    return;
                }
            }
            LOG.info("BINARY_DIFF_CPU_MONITORING", new Object[]{qualityDifference < 0 ? "Increasing" : "Reducing", this.lastReportedQuality, quality, 100 * utilisation / 255});
            this.lastReportedQuality = quality;
            this.suppressedQualityReports = 0;
        }
    }

    BinaryDiff.Result diff(byte[] a, int aoff, int n, byte[] b, int boff, int m, BinaryDiff.EditScript script, Quality quality) {
        MyersBinaryDiff.checkBounds(a, aoff, n);
        MyersBinaryDiff.checkBounds(b, boff, m);
        CoallescingScript editScript = new CoallescingScript(script, aoff, boff);
        Execution execution = new Execution(this.storage, quality.limit(this.initialLimit, n, m), a, b, editScript);
        boolean result = quality == Quality.LOWEST ? execution.trimPrefixAndSuffix(aoff, n, boff, m) : execution.diff(aoff, n, boff, m);
        return result ? editScript.close(n, m) : BinaryDiff.Result.REPLACE;
    }

    private static void checkBounds(byte[] array, int offset, int length) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("offset " + offset + " < 0");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("length " + length + " < 0");
        }
        if (offset + length > array.length || offset + length < 0) {
            throw new ArrayIndexOutOfBoundsException("offset " + offset + " + " + length + " > " + array.length);
        }
    }

    private static Quality qualityForUtilisation(int utilisation) {
        if (utilisation < THRESHOLD_1) {
            return Quality.HIGHEST;
        }
        if (utilisation < THRESHOLD_2) {
            return Quality.HIGH;
        }
        if (utilisation < THRESHOLD_3) {
            return Quality.MODERATE;
        }
        if (utilisation < THRESHOLD_4) {
            return Quality.LOW;
        }
        return Quality.LOWEST;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Quality {
        HIGHEST{

            @Override
            int limit(int defaultLimit, int n, int m) {
                return defaultLimit;
            }
        }
        ,
        HIGH{

            @Override
            int limit(int defaultLimit, int n, int m) {
                return Math.max(Math.min(defaultLimit, Math.min(n, m)) >> 2, 64);
            }
        }
        ,
        MODERATE{

            @Override
            int limit(int defaultLimit, int n, int m) {
                return HIGH.limit(defaultLimit, n, m) >> 2;
            }
        }
        ,
        LOW{

            @Override
            int limit(int defaultLimit, int n, int m) {
                return 1;
            }
        }
        ,
        LOWEST{

            @Override
            int limit(int defaultLimit, int n, int m) {
                return -1;
            }
        };


        abstract int limit(int var1, int var2, int var3);
    }

    private static final class Storage {
        private final int maximum;
        private final int maximumD;
        private int used;
        private int[] vector = new int[15];

        Storage(int maximum) {
            this.maximum = maximum;
            this.maximumD = (maximum - 3) / 4;
        }

        private void fill(int start, int[] result) {
            for (int i = start; i < this.used + 4; i += 4) {
                result[i + 0] = -1;
                result[i + 1] = -1;
                result[i + 2] = Integer.MAX_VALUE;
                result[i + 3] = Integer.MAX_VALUE;
            }
        }

        private int[] ensure(int d) {
            this.used = 4 * (d + 1) + 3;
            int[] original = this.vector;
            if (original.length >= this.used + 4) {
                return original;
            }
            int[] grown = Arrays.copyOf(original, this.used << 1);
            this.vector = grown;
            return grown;
        }

        int[] initialise(int d) {
            int[] result = this.ensure(d);
            this.fill(3, result);
            return result;
        }

        int[] extend(int d) {
            if (d > this.maximumD) {
                LOG.info("BINARY_DIFF_INSUFFICIENT_STORAGE", (Object)this.maximum);
                return null;
            }
            int originalUsed = this.used;
            int[] result = this.ensure(d);
            this.fill(originalUsed, result);
            return result;
        }
    }

    @NotThreadSafe
    private static final class CoallescingScript {
        private final BinaryDiff.EditScript delegate;
        private final int aOffset;
        private final int bOffset;
        private Op pendingOp = Op.NOOP;
        private int pendingStart;
        private int pendingLength;
        private boolean neverFlushed = true;

        CoallescingScript(BinaryDiff.EditScript delegate, int aOffset, int bOffset) {
            this.delegate = delegate;
            this.aOffset = aOffset;
            this.bOffset = bOffset;
        }

        boolean insert(int bStart, int length) {
            return this.process(Op.INSERT, bStart - this.bOffset, length);
        }

        boolean match(int aStart, int length) {
            return this.process(Op.MATCH, aStart - this.aOffset, length);
        }

        boolean delete() {
            if (this.pendingOp == Op.INSERT) {
                return true;
            }
            boolean r = this.flushPending();
            this.pendingOp = Op.NOOP;
            return r;
        }

        BinaryDiff.Result close(int aLength, int bLength) {
            if (this.neverFlushed) {
                if (this.pendingOp == Op.INSERT) {
                    assert (this.pendingStart == 0 && this.pendingLength == bLength) : this.pendingLength;
                    return BinaryDiff.Result.REPLACE;
                }
                if (this.pendingStart == 0 && this.pendingLength == aLength) {
                    return BinaryDiff.Result.NO_CHANGE;
                }
            }
            return this.flushPending() && this.delegate.close() ? BinaryDiff.Result.SUCCESS : BinaryDiff.Result.REPLACE;
        }

        private boolean flushPending() {
            this.neverFlushed &= this.pendingOp == Op.NOOP;
            return this.pendingOp.flush(this.delegate, this.pendingStart, this.pendingLength);
        }

        private boolean process(Op op, int start, int length) {
            if (length > 0) {
                if (this.pendingOp != op) {
                    if (!this.flushPending()) {
                        return false;
                    }
                    this.pendingOp = op;
                    this.pendingStart = start;
                    this.pendingLength = length;
                } else {
                    this.pendingLength += length;
                }
            }
            return true;
        }
    }

    private static class Execution {
        private final Storage storage;
        private final int executionLimit;
        private final byte[] a;
        private final byte[] b;
        private final CoallescingScript script;

        Execution(Storage storage, int executionLimit, byte[] a, byte[] b, CoallescingScript script) {
            this.storage = storage;
            this.executionLimit = executionLimit;
            this.a = a;
            this.b = b;
            this.script = script;
        }

        boolean diff(int aoff, int n, int boff, int m) {
            try {
                return this.diff(aoff, n, boff, m, this.executionLimit);
            }
            catch (StackOverflowError e) {
                LOG.warn("BINARY_DIFF_FAILURE", this.a.length, this.b.length, this.executionLimit, e);
                return false;
            }
        }

        boolean trimPrefixAndSuffix(int aoff, int n, int boff, int m) {
            int s = this.afterCommonPrefix(aoff, n, boff, m);
            boolean firstOp = this.script.match(aoff, s);
            assert (firstOp);
            int u = this.beforeCommonSuffix(aoff, n, boff, m, s);
            int v = u + m - n;
            boolean r = s == u ? this.script.insert(boff + s, v - s) : (s == v ? this.script.delete() : this.noDiff(boff + s, v - s));
            return r && this.script.match(aoff + u, n - u);
        }

        private boolean diff(int aoff, int n, int boff, int m, int limit) {
            int s = this.afterCommonPrefix(aoff, n, boff, m);
            return this.script.match(aoff, s) && this.diffNoPrefix(aoff, n, boff, m, s, limit);
        }

        private int afterCommonPrefix(int aoff, int n, int boff, int m) {
            int end = Math.min(n, m);
            int p = 0;
            while (p < end && this.a[aoff + p] == this.b[boff + p]) {
                ++p;
            }
            return p;
        }

        private int beforeCommonSuffix(int aoff, int n, int boff, int m, int s) {
            int delta = n - m;
            int end = Math.max(0, delta) + s;
            int bbase = boff - delta;
            int u = n - 1;
            while (u >= end && this.a[aoff + u] == this.b[bbase + u]) {
                --u;
            }
            return u + 1;
        }

        private boolean diffNoPrefix(int aoff, int n, int boff, int m, int s, int limit) {
            boolean r;
            int u = this.beforeCommonSuffix(aoff, n, boff, m, s);
            int v = u + m - n;
            if (s == u) {
                r = this.script.insert(boff + s, v - s);
            } else if (s == v) {
                r = this.script.delete();
            } else {
                assert (this.a[aoff + s] != this.b[boff + s]);
                assert (this.a[aoff + u - 1] != this.b[boff + v - 1]);
                r = this.middleSnake(aoff + s, u - s, boff + s, v - s, limit);
            }
            return r && this.script.match(aoff + u, n - u);
        }

        private boolean diffNoSuffix(int aoff, int n, int boff, int m, int limit) {
            int p = this.afterCommonPrefix(aoff, n, boff, m);
            if (!this.script.match(aoff, p)) {
                return false;
            }
            if (p == n) {
                return this.script.insert(boff + p, m - p);
            }
            if (p == m) {
                return this.script.delete();
            }
            assert (this.a[aoff + p] != this.b[boff + p]);
            assert (this.a[aoff + n - 1] != this.b[boff + m - 1]);
            return this.middleSnake(aoff + p, n - p, boff + p, m - p, limit);
        }

        private boolean middleSnake(int aoff, int n, int boff, int m, int limit) {
            int delta = n - m;
            boolean odd = (delta & 1) == 1;
            int[] vec = this.storage.initialise(1);
            Execution.forwardSet(vec, 0, 0);
            Execution.reverseSet(vec, 0, n);
            int d = 1;
            int l = limit;
            do {
                int cornerN = Execution.corner(d, n);
                int cornerM = Execution.corner(d, m);
                if (odd) {
                    for (k = -cornerN; k <= cornerM; k += 2) {
                        x = Execution.forwardGetNext(vec, k);
                        int u = x + this.afterCommonPrefix(aoff + x, n - x, boff + x + k, m - k - x);
                        int kd = k + delta;
                        if (Math.abs(kd) < d && u >= Execution.reverseGet(vec, kd)) {
                            Execution.assertDividedAndConquered(n, m, k, x, u);
                            return this.diffNoPrefix(aoff, x, boff, x + k, 0, this.executionLimit) && this.script.match(aoff + x, u - x) && this.diffNoSuffix(aoff + u, n - u, boff + u + k, m - u - k, this.executionLimit);
                        }
                        Execution.forwardSet(vec, k, u);
                    }
                    for (k = -cornerM; k <= cornerN; k += 2) {
                        u = Execution.reverseGetNext(vec, k);
                        Execution.reverseSet(vec, k, this.beforeCommonSuffix(aoff, u, boff, k - delta + u, 0));
                    }
                } else {
                    for (k = -cornerN; k <= cornerM; k += 2) {
                        x = Execution.forwardGetNext(vec, k);
                        Execution.forwardSet(vec, k, x + this.afterCommonPrefix(aoff + x, n - x, boff + x + k, m - k - x));
                    }
                    for (k = -cornerM; k <= cornerN; k += 2) {
                        u = Execution.reverseGetNext(vec, k);
                        int kd = k + m - n;
                        int x = this.beforeCommonSuffix(aoff, u, boff, kd + u, 0);
                        if (Math.abs(kd) <= d && x <= Execution.forwardGet(vec, kd)) {
                            Execution.assertDividedAndConquered(n, m, kd, x, u);
                            return this.diffNoPrefix(aoff, x, boff, x + kd, 0, this.executionLimit) && this.script.match(aoff + x, u - x) && this.diffNoSuffix(aoff + u, n - u, boff + u + kd, m - u - kd, this.executionLimit);
                        }
                        Execution.reverseSet(vec, k, x);
                    }
                }
                if ((d & 0x3F) == 0 && Execution.slowProgress(vec, n, m, cornerN, cornerM, d)) {
                    l -= 48;
                } else if (d > l) {
                    return this.bail(vec, aoff, n, boff, m, cornerN, cornerM, l);
                }
                assert ((long)(++d) <= ((long)n + (long)m) / 2L + 1L);
            } while ((vec = this.storage.extend(d)) != null);
            return false;
        }

        private static void assertDividedAndConquered(int n, int m, int k, int x, int u) {
            assert (x < n || x + k < m);
            assert (u > 0 || u + k > 0);
        }

        private static boolean slowProgress(int[] vec, int n, int m, int cornerN, int cornerM, int d) {
            int rbest;
            long xyforward = Execution.bestForward(vec, n, m, cornerN, cornerM);
            long xyreverse = Execution.bestReverse(vec, n, m, cornerN, cornerM);
            int fbest = Execution.x(xyforward) + Execution.y(xyforward);
            int progress = fbest + (rbest = n + m - Execution.x(xyreverse) - Execution.y(xyreverse));
            return progress < DiffusionMath.approximateSquareRoot(d) * d;
        }

        private static long bestForward(int[] vec, int n, int m, int cornerN, int cornerM) {
            int xforward = 0;
            int yforward = 0;
            for (int k = -cornerN; k <= cornerM; k += 2) {
                int y;
                int x = Math.min(Math.min(Execution.forwardGet(vec, k), n), m - k);
                if (x + (y = x + k) <= xforward + yforward) continue;
                xforward = x;
                yforward = y;
            }
            return Execution.intsToLong(xforward, yforward);
        }

        private static long bestReverse(int[] vec, int n, int m, int cornerN, int cornerM) {
            int xreverse = n;
            int yreverse = m;
            for (int k = -cornerM; k <= cornerN; k += 2) {
                int y;
                int kd = k - (n - m);
                int x = Math.max(Math.max(Execution.reverseGet(vec, k), 0), -kd);
                if (x + (y = x + kd) >= xreverse + yreverse) continue;
                xreverse = x;
                yreverse = y;
            }
            return Execution.intsToLong(xreverse, yreverse);
        }

        private boolean bail(int[] vec, int aoff, int n, int boff, int m, int cornerN, int cornerM, int limit) {
            long xyforward = Execution.bestForward(vec, n, m, cornerN, cornerM);
            int xforward = Execution.x(xyforward);
            int yforward = Execution.y(xyforward);
            long xyreverse = Execution.bestReverse(vec, n, m, cornerN, cornerM);
            int xreverse = Execution.x(xyreverse);
            int yreverse = Execution.y(xyreverse);
            if (xforward >= xreverse || yforward >= yreverse) {
                int y;
                int x;
                if (n + m - xreverse - yreverse > xforward + yforward) {
                    x = xreverse;
                    y = yreverse;
                } else {
                    x = xforward;
                    y = yforward;
                }
                return this.boundedSplitDiff(aoff, x, n, boff, y, m, limit);
            }
            return this.diffNoPrefix(aoff, xforward, boff, yforward, 0, this.executionLimit) && this.boundedDiff(aoff + xforward, xreverse - xforward, boff + yforward, yreverse - yforward, n, m, limit) && this.diffNoSuffix(aoff + xreverse, n - xreverse, boff + yreverse, m - yreverse, this.executionLimit);
        }

        private boolean boundedSplitDiff(int aoff, int n1, int n2, int boff, int m1, int m2, int limit) {
            if (n2 > m2) {
                if (!(m1 != 0 && m1 != m2 || Execution.atLeastAnEighth(n1, n2))) {
                    return this.splitDiff(aoff, n2 / 2, n2, boff, m1, m2, limit / 2);
                }
            } else if (!(n1 != 0 && n1 != n2 || Execution.atLeastAnEighth(m1, m2))) {
                return this.splitDiff(aoff, n1, n2, boff, m2 / 2, m2, limit / 2);
            }
            return this.splitDiff(aoff, n1, n2, boff, m1, m2);
        }

        private static boolean atLeastAnEighth(int x, int y) {
            return 8L * (long)Math.min(x, y - x) > (long)y;
        }

        private boolean boundedDiff(int aoff, int n, int boff, int m, int totalN, int totalM, int limit) {
            if (Math.min(n, m) < 8 || Execution.largeSpace(n, m, totalN, totalM)) {
                if (limit <= 0) {
                    int n0 = n / 4;
                    int n1 = n0 + n / 2;
                    int m0 = m / 4;
                    int m1 = m0 + m / 2;
                    return this.noDiff(boff, m0) && this.diff(aoff + n0, n1 - n0, boff + m0, m1 - m0, limit / 2) && this.noDiff(boff + m1, m - m1);
                }
                return this.splitDiff(aoff, n / 2, n, boff, m / 2, m, limit / 2);
            }
            return this.middleSnake(aoff, n, boff, m, Math.max(8, limit));
        }

        private static boolean largeSpace(int n, int m, int totalN, int totalM) {
            long nm = (long)n * (long)m;
            long totalSpace = (long)totalN * (long)totalM;
            long threshold = 0x1000000L + totalSpace / 2L;
            return nm >= threshold;
        }

        private boolean splitDiff(int aoff, int n1, int n2, int boff, int m1, int m2) {
            return this.diffNoPrefix(aoff, n1, boff, m1, 0, this.executionLimit) && this.diffNoSuffix(aoff + n1, n2 - n1, boff + m1, m2 - m1, this.executionLimit);
        }

        private boolean splitDiff(int aoff, int n1, int n2, int boff, int m1, int m2, int limit) {
            return this.diffNoPrefix(aoff, n1, boff, m1, 0, limit) && this.diffNoSuffix(aoff + n1, n2 - n1, boff + m1, m2 - m1, limit);
        }

        private boolean noDiff(int boff, int m) {
            return this.script.insert(boff, m) && this.script.delete();
        }

        private static int forwardKey(int k) {
            return k < 0 ? -4 * k - 1 : 4 * k;
        }

        private static int forwardGet(int[] vec, int k) {
            return vec[Execution.forwardKey(k)];
        }

        private static void forwardSet(int[] vec, int k, int i) {
            vec[Execution.forwardKey((int)k)] = i;
        }

        private static int forwardGetNext(int[] vec, int k) {
            int right;
            int left = Execution.forwardGet(vec, k + 1);
            if (left < (right = Execution.forwardGet(vec, k - 1))) {
                return right;
            }
            return left + 1;
        }

        private static int reverseKey(int k) {
            return Execution.forwardKey(k) + 2;
        }

        private static int reverseGet(int[] vec, int k) {
            return vec[Execution.reverseKey(k)];
        }

        private static void reverseSet(int[] vec, int k, int i) {
            vec[Execution.reverseKey((int)k)] = i;
        }

        private static int reverseGetNext(int[] vec, int k) {
            int right;
            int left = Execution.reverseGet(vec, k + 1);
            if (left < (right = Execution.reverseGet(vec, k - 1))) {
                return left;
            }
            return right - 1;
        }

        private static int corner(int d, int length) {
            if (d <= length) {
                return d;
            }
            return 2 * length - d;
        }

        private static long intsToLong(int x, int y) {
            return (long)x + ((long)y << 32);
        }

        private static int x(long xy) {
            return (int)xy;
        }

        private static int y(long xy) {
            return (int)(xy >> 32);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Op {
        INSERT{

            @Override
            boolean flush(BinaryDiff.EditScript script, int start, int length) {
                return script.insert(start, length);
            }
        }
        ,
        MATCH{

            @Override
            boolean flush(BinaryDiff.EditScript script, int start, int length) {
                return script.match(start, length);
            }
        }
        ,
        NOOP;


        boolean flush(BinaryDiff.EditScript script, int start, int length) {
            return true;
        }
    }
}

