/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.datatype.diff;

import com.pushtechnology.diffusion.time.SystemTime;
import com.pushtechnology.diffusion.utils.math.DiffusionMath;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class ActivityHistory {
    private final long[] buckets;
    private final long bucketWidth;
    private final long bucketOffsetMask;
    private final int bucketShift;
    private final int mask;
    private long lastBucket;
    private long lastStart;
    private long cumulative;
    private final int normaliseShift;

    ActivityHistory(int bucketCount, long bucketMillis) {
        this.bucketWidth = DiffusionMath.findNextPowerOfTwo(bucketMillis);
        this.bucketOffsetMask = this.bucketWidth - 1L;
        this.bucketShift = DiffusionMath.highestBit(this.bucketWidth) - 1;
        int bc = DiffusionMath.findNextPowerOfTwo(bucketCount);
        this.normaliseShift = this.bucketShift + DiffusionMath.highestBit(bc) - 9;
        this.buckets = new long[bc];
        this.mask = this.buckets.length - 1;
    }

    private long bucket(long t) {
        return t >> this.bucketShift;
    }

    private long bucketOffset(long t) {
        return t & this.bucketOffsetMask;
    }

    private int mask(long bucket) {
        return (int)(bucket & (long)this.mask);
    }

    int utilisation() {
        long cumulativeWithoutLastBucket = this.cumulative - this.buckets[this.mask(this.lastBucket)] + this.buckets[this.mask(this.lastBucket - 1L)];
        return (int)cumulativeWithoutLastBucket >> this.normaliseShift;
    }

    void start() {
        long now = SystemTime.currentTimeMillis();
        long bucket = this.bucket(now);
        long oldestBucket = bucket - (long)this.buckets.length + 1L;
        for (long b = Math.max(this.lastBucket + 1L, oldestBucket); b <= bucket; ++b) {
            this.setBucket(b, 0L);
        }
        this.lastBucket = bucket;
        this.lastStart = now;
    }

    void stop() {
        long now = SystemTime.currentTimeMillis();
        if (now > this.lastStart) {
            long bucket = this.bucket(now);
            if (bucket == this.lastBucket) {
                this.accumulateBucket(this.lastBucket, now - this.lastStart);
            } else {
                this.accumlateBuckets(bucket, now);
            }
        }
    }

    private void accumlateBuckets(long endBucket, long now) {
        long oldestBucket = endBucket - (long)this.buckets.length + 1L;
        long start = Math.max(this.lastBucket, oldestBucket);
        this.accumulateBucket(start, this.bucketWidth - this.bucketOffset(this.lastStart));
        for (long b = start + 1L; b < endBucket; ++b) {
            this.setBucket(b, this.bucketWidth - 1L);
        }
        this.accumulateBucket(endBucket, this.bucketOffset(now));
    }

    private void accumulateBucket(long bucket, long delta) {
        int i = this.mask(bucket);
        long oldValue = this.buckets[i];
        long newValue = Math.min(oldValue + delta, this.bucketWidth - 1L);
        this.cumulative += newValue - oldValue;
        this.buckets[i] = newValue;
    }

    private void setBucket(long bucket, long delta) {
        int i = this.mask(bucket);
        this.cumulative += delta - this.buckets[i];
        this.buckets[i] = delta;
    }
}

