/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.conversation;

import com.pushtechnology.diffusion.conversation.ConversationId;
import com.pushtechnology.diffusion.conversation.ConversationIdsExhausted;
import java.util.concurrent.atomic.AtomicLong;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class ConversationIdGenerator {
    private final AtomicLong next;

    public ConversationIdGenerator() {
        this(1L);
    }

    ConversationIdGenerator(long seed) {
        this.next = new AtomicLong(seed);
    }

    public ConversationId create() {
        long id = this.next.getAndIncrement();
        if (id < 0L) {
            throw new ConversationIdsExhausted(this);
        }
        return new ConversationId(id);
    }

    public String toString() {
        long nextId = this.next.get();
        if (nextId < 0L) {
            return "ConversationIdGenerator (values exhausted)";
        }
        return "ConversationIdGenerator (next value: " + nextId + ")";
    }
}

