/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.constraints;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.datatype.DataType;

public enum ConstraintValueType {
    NULL,
    STRING,
    INT64,
    DOUBLE,
    BINARY,
    JSON,
    RECORD_V2,
    BOOLEAN;

    private static final EnumConverter<ConstraintValueType> CONVERTOR;

    static ConstraintValueType fromByte(byte b) {
        return CONVERTOR.fromByte(b);
    }

    static byte toByte(ConstraintValueType operator) {
        return CONVERTOR.toByte(operator);
    }

    public static ConstraintValueType fromDataType(DataType<?> dataType) {
        switch (dataType.getTypeName()) {
            case "binary": {
                return BINARY;
            }
            case "double": {
                return DOUBLE;
            }
            case "int64": {
                return INT64;
            }
            case "json": {
                return JSON;
            }
            case "record_v2": {
                return RECORD_V2;
            }
            case "string": {
                return STRING;
            }
        }
        throw new IllegalStateException(dataType.toString());
    }

    static {
        CONVERTOR = new EnumConverter.Builder<ConstraintValueType>(ConstraintValueType.class).bimap(0, NULL).bimap(1, STRING).bimap(2, INT64).bimap(3, DOUBLE).bimap(4, BINARY).bimap(5, JSON).bimap(6, RECORD_V2).bimap(7, BOOLEAN).build();
    }
}

