/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.constraints;

import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.client.session.Session;
import com.pushtechnology.diffusion.constraints.ConstraintValueType;
import com.pushtechnology.diffusion.constraints.Locked;
import com.pushtechnology.diffusion.constraints.NoTopic;
import com.pushtechnology.diffusion.constraints.NoValue;
import com.pushtechnology.diffusion.constraints.PartialJSONImpl;
import com.pushtechnology.diffusion.constraints.TopicValueConstraint;
import com.pushtechnology.diffusion.datatype.Bytes;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import java.util.Objects;

public final class ConstraintFactory
implements UpdateConstraint.Factory {
    private final DataTypes dataTypes;

    public ConstraintFactory(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public UpdateConstraint locked(Session.SessionLock lock) {
        return new Locked(lock);
    }

    @Override
    public UpdateConstraint value(UpdateConstraint.Operator operator, Object suppliedValue) {
        Class<Object> valueClass;
        Object value;
        Objects.requireNonNull(operator, "operator is null");
        Class<?> suppliedClass = Objects.requireNonNull(suppliedValue, "value is null").getClass();
        if (suppliedClass == Integer.class) {
            value = ((Integer)suppliedValue).longValue();
            valueClass = Long.class;
        } else {
            value = suppliedValue;
            valueClass = suppliedClass;
        }
        if (operator == UpdateConstraint.Operator.IS) {
            Bytes bytes;
            if (value instanceof Bytes) {
                bytes = (Bytes)value;
            } else {
                DataType<?> dataType;
                try {
                    dataType = this.dataTypes.getByClass(valueClass);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException("value type " + valueClass.getSimpleName() + " is not supported with the " + String.valueOf((Object)operator) + " operator");
                }
                bytes = dataType.toBytes(value);
            }
            return new TopicValueConstraint(UpdateConstraint.Operator.IS, ConstraintValueType.BINARY, bytes);
        }
        if (valueClass == String.class) {
            if (!ConstraintFactory.isEqualityOperator(operator)) {
                throw new IllegalArgumentException("Invalid operator for String value");
            }
        } else if (valueClass != Long.class && valueClass != Double.class) {
            throw new IllegalArgumentException("value type " + valueClass.getSimpleName() + " is not supported with the " + String.valueOf((Object)operator) + " operator");
        }
        DataType<Object> dataType = this.dataTypes.getByClass(valueClass);
        return new TopicValueConstraint(operator, ConstraintValueType.fromDataType(dataType), dataType.toBytes(value));
    }

    @Override
    public UpdateConstraint noValue() {
        return NoValue.get();
    }

    @Override
    public UpdateConstraint noTopic() {
        return NoTopic.get();
    }

    @Override
    public UpdateConstraint.PartialJSON jsonValue() {
        return new PartialJSONImpl(this.dataTypes);
    }

    static boolean isEqualityOperator(UpdateConstraint.Operator operator) {
        return operator == UpdateConstraint.Operator.IS || operator == UpdateConstraint.Operator.EQ || operator == UpdateConstraint.Operator.NE;
    }
}

