/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.constraints;

import com.pushtechnology.diffusion.client.features.UpdateConstraint;
import com.pushtechnology.diffusion.constraints.Conjunction;
import com.pushtechnology.diffusion.constraints.Disjunction;
import com.pushtechnology.diffusion.constraints.UpdateConstraintSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
final class ConjunctionSerialiser
extends AbstractSerialiser<Conjunction> {
    private final UpdateConstraintSerialiser constraintSerialiser;

    ConjunctionSerialiser(UpdateConstraintSerialiser constraintSerialiser) {
        this.constraintSerialiser = constraintSerialiser;
    }

    @Override
    public void write(OutputStream out, Conjunction conjunction) throws IOException {
        ArrayList<UpdateConstraint> constraintList = new ArrayList<UpdateConstraint>();
        ConjunctionSerialiser.expand(conjunction, constraintList);
        ConjunctionSerialiser.writeCollection(out, this.constraintSerialiser, constraintList);
    }

    private static void expand(UpdateConstraint constraint, List<UpdateConstraint> constraintList) throws IOException {
        if (constraint instanceof Conjunction) {
            Conjunction conjunction = (Conjunction)constraint;
            ConjunctionSerialiser.expand(conjunction.getLeft(), constraintList);
            ConjunctionSerialiser.expand(conjunction.getRight(), constraintList);
        } else {
            if (constraint instanceof Disjunction) {
                throw new IOException("Disjunction not supported");
            }
            constraintList.add(constraint);
        }
    }

    @Override
    protected Conjunction readUnchecked(InputStream in) throws IOException {
        List constraints = ConjunctionSerialiser.readCollection(in, ArrayList::new, this.constraintSerialiser);
        if (constraints.size() < 2) {
            throw new IOException("At least two constraints are required to create a nested conjunction.");
        }
        return (Conjunction)ConjunctionSerialiser.createNestedConjunction(constraints);
    }

    private static UpdateConstraint createNestedConjunction(List<UpdateConstraint> constraints) {
        if (constraints.size() == 2) {
            return new Conjunction(constraints.get(0), constraints.get(1));
        }
        if (constraints.size() > 2) {
            UpdateConstraint firstConstraint = constraints.get(0);
            UpdateConstraint secondConstraint = constraints.get(1);
            List<UpdateConstraint> remainingConstraints = constraints.subList(2, constraints.size());
            UpdateConstraint nestedConjunction = ConjunctionSerialiser.createNestedConjunction(remainingConstraints);
            return new Conjunction(new Conjunction(firstConstraint, secondConstraint), nestedConjunction);
        }
        return constraints.get(0);
    }
}

