/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.connection.activity.monitor;

import com.pushtechnology.diffusion.comms.connection.OutboundConnection;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitor;
import com.pushtechnology.diffusion.connection.activity.monitor.ConnectionActivityMonitorFactory;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.message.MessageChannelClosedReason;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.ConfigurationUtils;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class ConnectionActivityMonitorFactoryImpl
implements ConnectionActivityMonitorFactory {
    private static final Logger LOG = I18nLogger.getLogger(ConnectionActivityMonitorFactoryImpl.class);
    private static final double MONITOR_TIMEOUT_FACTOR = ConfigurationUtils.getDoubleSystemProperty("diffusion.activity.monitor.timeout.factor", 2.0);
    private final CommonThreadPools commonThreadPools;

    public ConnectionActivityMonitorFactoryImpl(CommonThreadPools commonThreadPools) {
        this.commonThreadPools = commonThreadPools;
    }

    @Override
    public ConnectionActivityMonitor create(OutboundConnection outboundConnection) {
        long systemPingPeriod = outboundConnection.getResponse().getSystemPingPeriod();
        assert (systemPingPeriod > 0L) : "Only connections with a system ping should be monitored";
        long pingTimeout = (long)((double)systemPingPeriod * MONITOR_TIMEOUT_FACTOR);
        DisconnectTask idleTask = new DisconnectTask(outboundConnection);
        return new ConnectionActivityMonitorImpl(pingTimeout, idleTask);
    }

    static {
        if (MONITOR_TIMEOUT_FACTOR < 1.0) {
            throw new IllegalStateException("The diffusion.activity.monitor.timeout.factor system property must be greater than 1");
        }
    }

    @ThreadSafe
    private static final class DisconnectTask
    implements Runnable {
        private final OutboundConnection outboundConnection;

        private DisconnectTask(OutboundConnection outboundConnection) {
            this.outboundConnection = outboundConnection;
        }

        @Override
        public void run() {
            LOG.warn("IDLE_CONNECTION_CLOSE", (Object)this.outboundConnection);
            this.outboundConnection.closeConnection(MessageChannelClosedReason.IDLE_CONNECTION, null);
        }
    }

    @ThreadSafe
    private final class ConnectionActivityMonitorImpl
    implements ConnectionActivityMonitor {
        private final long pingTimeout;
        private final DisconnectTask idleTask;
        @GuardedBy(value="this")
        private Future<?> currentTask;

        private ConnectionActivityMonitorImpl(long pingTimeout, DisconnectTask idleTask) {
            this.pingTimeout = pingTimeout;
            this.idleTask = idleTask;
            this.currentTask = ConnectionActivityMonitorFactoryImpl.this.commonThreadPools.getBackgroundThreadPool().schedule(idleTask, pingTimeout, TimeUnit.MILLISECONDS);
            LOG.debug("Connection activity monitor for {} was created", (Object)idleTask.outboundConnection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSystemPing() {
            ConnectionActivityMonitorImpl connectionActivityMonitorImpl = this;
            synchronized (connectionActivityMonitorImpl) {
                if (this.currentTask != null) {
                    this.currentTask.cancel(false);
                    this.currentTask = ConnectionActivityMonitorFactoryImpl.this.commonThreadPools.getBackgroundThreadPool().schedule(this.idleTask, this.pingTimeout, TimeUnit.MILLISECONDS);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            ConnectionActivityMonitorImpl connectionActivityMonitorImpl = this;
            synchronized (connectionActivityMonitorImpl) {
                this.currentTask.cancel(false);
                LOG.debug("Connection activity monitor for {} was shutdown", (Object)this.idleTask.outboundConnection);
                this.currentTask = null;
            }
        }
    }
}

