/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.websocket;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.api.internal.connection.OutboundHandshakeFactory;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.comms.connection.AbstractHTTPOutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.ConnectionCapabilities;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.request.ConnectOrReconnectRequest;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.Protocol4CredentialsTunnel;
import com.pushtechnology.diffusion.comms.connection.request.ReconnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReverseConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponseDeserialiser;
import com.pushtechnology.diffusion.comms.websocket.WebSocketConstants;
import com.pushtechnology.diffusion.comms.websocket.WebSocketFrameCodec;
import com.pushtechnology.diffusion.http.HTTPConstants;
import com.pushtechnology.diffusion.http.HTTPHeaders;
import com.pushtechnology.diffusion.http.URIEncoder;
import com.pushtechnology.diffusion.io.ByteSink;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStream;
import com.pushtechnology.diffusion.io.bytes.IBytesOutputStreamImpl;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.utils.Base64;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import com.pushtechnology.diffusion.utils.FastEncoder;
import com.pushtechnology.diffusion.utils.PropertyUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import net.jcip.annotations.Immutable;

@Immutable
public final class WebSocketOutboundHandshake
extends AbstractHTTPOutboundHandshake {
    private static final byte[] GET_BYTES = CharsetUtils.stringToASCII("GET ");
    public static final OutboundHandshakeFactory FACTORY = (serverDetails, maximumMessageSize, backgroundThreadPool) -> new WebSocketOutboundHandshake(serverDetails, backgroundThreadPool, maximumMessageSize);
    private static final RequestFormatter<ConnectionRequest> CONNECTION_FORMATTER = new ConnectionFormatter();
    private static final RequestFormatter<ReconnectionRequest> RECONNECTION_FORMATTER = new ReconnectionFormatter();
    private static final RequestFormatter<ReverseConnectionRequest> REVERSE_CONNECTION_FORMATTER = new ReverseConnectionFormatter();
    private final ByteBufferDeserialiser responseDeserialiser = bb -> new WebSocketFrameCodec(new ConnectionResponseDeserialiser(), maxMessageSize, true).readFrame(bb, null);
    private final String requestKey;

    WebSocketOutboundHandshake(ServerDetails serverDetails, ScheduledExecutorService backgroundThreadPool, int maxMessageSize) {
        super(serverDetails, backgroundThreadPool);
        byte[] r = new byte[16];
        ThreadLocalRandom.current().nextBytes(r);
        this.requestKey = Base64.encode(r);
    }

    private <T> void sendRequest(ByteSink channel, RequestFormatter<T> requestFormatter, T request) throws IOException {
        IBytesOutputStreamImpl out = IBytesOutputStreamImpl.forThread();
        ServerDetails serverDetails = this.getServerDetails();
        ((IBytesOutputStream)out).write(GET_BYTES);
        URIEncoder.percentEncodePath(serverDetails.getPath(), out);
        InternalConnectionType connectionType = ((ConnectOrReconnectRequest)request).getConnectionType();
        if (connectionType.equals((Object)InternalConnectionType.WEBSOCKET_FANOUT_CLIENT)) {
            ((IBytesOutputStream)out).write(63);
            requestFormatter.addToParameters(out, request);
        }
        ((IBytesOutputStream)out).write(HTTPConstants.HTTP_VERSION_CRLF_BYTES);
        ((IBytesOutputStream)out).write(WebSocketConstants.UPGRADE_CRLF_BYTES);
        ((IBytesOutputStream)out).write(WebSocketConstants.CONNECTION_CRLF_BYTES);
        String host = serverDetails.getHost();
        int port = serverDetails.getPort();
        ((IBytesOutputStream)out).write(HTTPConstants.HOST_BYTES);
        URIEncoder.percentEncode(host, out);
        ((IBytesOutputStream)out).write(58);
        FastEncoder.utf8Encode(Integer.toString(port), out);
        ((IBytesOutputStream)out).write(HTTPConstants.CRLF);
        ((IBytesOutputStream)out).write(WebSocketConstants.SEC_WEBSOCKET_VERSION_HEADER_BYTES);
        ((IBytesOutputStream)out).write(HTTPConstants.CRLF);
        ((IBytesOutputStream)out).write(WebSocketConstants.SEC_WEBSOCKET_KEY_BYTES);
        FastEncoder.utf8Encode(this.requestKey, out);
        ((IBytesOutputStream)out).write(HTTPConstants.CRLF);
        requestFormatter.addToHeaders(out, request);
        ((IBytesOutputStream)out).write(HTTPConstants.CRLF);
        ByteBuffer bb = ByteBuffer.allocate(((IBytesOutputStream)out).length());
        ((IBytesOutputStream)out).copyTo(bb);
        bb.flip();
        channel.write(bb, this.getServerDetails().getWriteTimeout());
    }

    @Override
    protected void sendConnectRequest(ByteSink channel, ConnectionRequest request) throws IOException {
        this.sendRequest(channel, CONNECTION_FORMATTER, request);
    }

    @Override
    protected void sendReconnectRequest(ByteSink channel, ReconnectionRequest request) throws IOException {
        this.sendRequest(channel, RECONNECTION_FORMATTER, request);
    }

    @Override
    protected void sendReverseConnectRequest(ByteSink channel, ReverseConnectionRequest request) throws IOException {
        this.sendRequest(channel, REVERSE_CONNECTION_FORMATTER, request);
    }

    private static void encodeParameter(OutputStream out, byte[] key, String value) throws IOException {
        out.write(38);
        out.write(key);
        out.write(61);
        FastEncoder.asciiEncode(value, out);
    }

    private static void encodeParameter(OutputStream out, byte[] key, int value) throws IOException {
        WebSocketOutboundHandshake.encodeParameter(out, key, Integer.toString(value));
    }

    private static void percentEncodeParameter(OutputStream out, byte[] key, String value) throws IOException {
        out.write(38);
        out.write(key);
        out.write(61);
        URIEncoder.percentEncode(value, out);
    }

    private static void encodeConnectionInfo(OutputStream out, ProtocolVersion protocolVersion, InternalConnectionType connectionType, ConnectionCapabilities capabilities) throws IOException {
        WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.VERSION_HEADER_BYTES, protocolVersion.asByte());
        WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.TYPE_HEADER_BYTES, connectionType.getHeaderValue());
        WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.CAPABILITIES_HEADER_BYTES, capabilities.asByte());
    }

    private static void encodeConnectionInfoToParameters(OutputStream out, ProtocolVersion protocolVersion, InternalConnectionType connectionType, ConnectionCapabilities capabilities) throws IOException {
        out.write(HTTPConstants.VERSION_HEADER_BYTES);
        out.write(61);
        out.write(CharsetUtils.stringToASCII(Byte.toString(protocolVersion.asByte())));
        WebSocketOutboundHandshake.encodeParameter(out, HTTPConstants.TYPE_HEADER_BYTES, connectionType.getHeaderValue());
        WebSocketOutboundHandshake.encodeParameter(out, HTTPConstants.CAPABILITIES_HEADER_BYTES, capabilities.asByte());
    }

    private String expectedResponseKey() {
        MessageDigest messageDigest = WebSocketConstants.HTTP_SHA1.get();
        String concatenated = this.requestKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        messageDigest.update(CharsetUtils.stringToASCII(concatenated));
        return Base64.encode(messageDigest.digest());
    }

    @Override
    protected ConnectionResponse processResponse(NetworkChannel channel, ByteBuffer initialBuffer) throws IOException {
        HTTPHeaders headers = this.readHttpHeaders(channel, initialBuffer);
        String status = headers.getFirstLine();
        if (!status.equalsIgnoreCase("HTTP/1.1 101 Switching Protocols")) {
            throw new ConnectionException("Response is not HTTP/1.1 101 Switching Protocols - " + status);
        }
        String acceptValue = headers.find("Sec-WebSocket-Accept");
        if (!this.expectedResponseKey().equals(acceptValue)) {
            throw new ConnectionException("Invalid websocket security key: " + acceptValue);
        }
        return this.readConnectionResponse(channel, initialBuffer, this.responseDeserialiser);
    }

    private static interface RequestFormatter<T> {
        public void addToHeaders(OutputStream var1, T var2) throws IOException;

        public void addToParameters(OutputStream var1, T var2) throws IOException;
    }

    private static final class ConnectionFormatter
    implements RequestFormatter<ConnectionRequest> {
        private ConnectionFormatter() {
        }

        @Override
        public void addToParameters(OutputStream out, ConnectionRequest request) throws IOException {
            WebSocketOutboundHandshake.encodeConnectionInfoToParameters(out, request.getProtocolVersion(), request.getConnectionType(), request.getCapabilities());
            WebSocketOutboundHandshake.percentEncodeParameter(out, HTTPConstants.PRINCIPAL_HEADER_BYTES, request.getPrincipal());
            if (request.getCredentials().getType() != Credentials.Type.NONE) {
                WebSocketOutboundHandshake.percentEncodeParameter(out, HTTPConstants.PASSWORD_HEADER_BYTES, Protocol4CredentialsTunnel.INSTANCE.encodeAsString(request.getCredentials()));
            }
            WebSocketOutboundHandshake.encodeParameter(out, HTTPConstants.RECONNECT_TIMEOUT_HEADER_BYTES, request.getReconnectionTimeout());
            String serverUUID = request.getServerUUID();
            if (serverUUID != null) {
                WebSocketOutboundHandshake.percentEncodeParameter(out, HTTPConstants.SERVER_UUID_HEADER_BYTES, serverUUID);
            }
        }

        @Override
        public void addToHeaders(OutputStream out, ConnectionRequest request) throws IOException {
            Map<String, String> sessionProperties;
            WebSocketOutboundHandshake.encodeConnectionInfo(out, request.getProtocolVersion(), request.getConnectionType(), request.getCapabilities());
            WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.PRINCIPAL_HEADER_BYTES, request.getPrincipal());
            if (request.getCredentials().getType() != Credentials.Type.NONE) {
                WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.PASSWORD_HEADER_BYTES, Protocol4CredentialsTunnel.INSTANCE.encodeAsString(request.getCredentials()));
            }
            if (!(sessionProperties = request.getProposedSessionProperties()).isEmpty()) {
                WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.SESSION_PROPERTIES_HEADER_BYTES, PropertyUtils.mapToString(sessionProperties));
            }
            WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.RECONNECT_TIMEOUT_HEADER_BYTES, request.getReconnectionTimeout());
            String serverUUID = request.getServerUUID();
            if (serverUUID != null) {
                WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.SERVER_UUID_HEADER_BYTES, serverUUID);
            }
        }
    }

    private static final class ReconnectionFormatter
    implements RequestFormatter<ReconnectionRequest> {
        private ReconnectionFormatter() {
        }

        @Override
        public void addToParameters(OutputStream out, ReconnectionRequest request) throws IOException {
            WebSocketOutboundHandshake.encodeConnectionInfoToParameters(out, request.getProtocolVersion(), request.getConnectionType(), request.getCapabilities());
            WebSocketOutboundHandshake.percentEncodeParameter(out, HTTPConstants.SESSION_TOKEN_HEADER_BYTES, request.getToken().toString());
            WebSocketOutboundHandshake.encodeParameter(out, HTTPConstants.AVAILABLE_CLIENT_SEQUENCE_HEADER_BYTES, request.availableClientSequence());
            WebSocketOutboundHandshake.encodeParameter(out, HTTPConstants.LAST_SERVER_SEQUENCE_HEADER_BYTES, request.lastServerSequence());
        }

        @Override
        public void addToHeaders(OutputStream out, ReconnectionRequest request) throws IOException {
            WebSocketOutboundHandshake.encodeConnectionInfo(out, request.getProtocolVersion(), request.getConnectionType(), request.getCapabilities());
            WebSocketOutboundHandshake.encodeSessionToken(out, request.getToken());
            WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.AVAILABLE_CLIENT_SEQUENCE_HEADER_BYTES, request.availableClientSequence());
            WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.LAST_SERVER_SEQUENCE_HEADER_BYTES, request.lastServerSequence());
        }
    }

    private static final class ReverseConnectionFormatter
    implements RequestFormatter<ReverseConnectionRequest> {
        private ReverseConnectionFormatter() {
        }

        @Override
        public void addToParameters(OutputStream out, ReverseConnectionRequest baseRequest) throws IOException {
            throw new UnsupportedOperationException("Parameters not supported for reverse connections");
        }

        @Override
        public void addToHeaders(OutputStream out, ReverseConnectionRequest request) throws IOException {
            WebSocketOutboundHandshake.encodeConnectionInfo(out, request.getProtocolVersion(), request.getConnectionType(), request.getCapabilities());
            WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.REMOTE_SERVER_HEADER_BYTES, request.getRemoteServerName());
            WebSocketOutboundHandshake.encodeHeader(out, HTTPConstants.RECONNECT_TIMEOUT_HEADER_BYTES, 0);
            WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.REVERSE_REQUEST_ID_HEADER_BYTES, request.getRequestId());
            WebSocketOutboundHandshake.percentEncodeHeader(out, HTTPConstants.SERVER_UUID_HEADER_BYTES, request.getServerUUID());
        }
    }
}

