/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.websocket;

import com.pushtechnology.diffusion.util.concurrent.threads.FastThreadLocal;
import com.pushtechnology.diffusion.utils.CharsetUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class WebSocketConstants {
    public static final FastThreadLocal<MessageDigest> HTTP_SHA1 = FastThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    });
    public static final String WEB_SOCKET_HTTP_RESPONSE_V10 = "HTTP/1.1 101 Switching Protocols";
    public static final byte[] WEB_SOCKET_HTTP_RESPONSE_V10_CRLF_BYTES = CharsetUtils.stringToASCII("HTTP/1.1 101 Switching Protocols\r\n");
    public static final byte[] UPGRADE_CRLF_BYTES = CharsetUtils.stringToASCII("Upgrade: WebSocket\r\n");
    public static final byte[] CONNECTION_CRLF_BYTES = CharsetUtils.stringToASCII("Connection: Upgrade\r\n");
    public static final byte[] SEC_WEBSOCKET_VERSION_HEADER_BYTES = CharsetUtils.stringToASCII("Sec-WebSocket-Version: 13");
    public static final byte[] SEC_WEBSOCKET_ORIGIN_BYTES = CharsetUtils.stringToASCII("Sec-WebSocket-Origin: ");
    public static final String WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    public static final byte[] WEBSOCKET_ACCEPT_BYTES = CharsetUtils.stringToASCII("Sec-WebSocket-Accept: ");
    public static final byte[] SEC_WEBSOCKET_KEY_BYTES = CharsetUtils.stringToASCII("Sec-WebSocket-Key: ");
    public static final String WEBSOCKET_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final byte[] WEBSOCKET_GUID_BYTES = CharsetUtils.stringToASCII("258EAFA5-E914-47DA-95CA-C5AB0DC85B11");
    public static final String UPGRADE_HEADER = "upgrade";
    public static final String ORIGIN_HEADER = "origin";
    public static final String UPGRADE_HEADER_VALUE = "WebSocket";
    public static final String SEC_WEBSOCKET_KEY = "sec-websocket-key";
    public static final String SEC_WEBSOCKET_VERSION = "sec-websocket-version";
    public static final String WEBSOCKET_PROTOCOL_HEADER = "sec-websocket-protocol";
    public static final byte PAYLOAD_LENGTH_SIZE8 = 127;
    public static final byte PAYLOAD_LENGTH_SIZE2 = 126;
    public static final byte CLOSE_OPCODE = 8;
    public static final byte PING_OPCODE = 9;
    public static final byte PONG_OPCODE = 10;
    public static final byte CONTINUATION_OPCODE = 0;
    public static final byte TEXT_FRAME_OPCODE = 1;
    public static final byte BINARY_FRAME_OPCODE = 2;
    public static final byte MASK_FLAG = -128;
    public static final byte FIN_FLAG = -128;
    public static final byte BINARY_FRAME_PREFIX = -126;

    private WebSocketConstants() {
    }
}

