/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.websocket;

import com.pushtechnology.diffusion.message.AbortNotificationMessage;
import com.pushtechnology.diffusion.message.ClientTopicMessage;
import com.pushtechnology.diffusion.message.Message;
import com.pushtechnology.diffusion.message.MessageEncoding;
import com.pushtechnology.diffusion.message.MessageParser;
import com.pushtechnology.diffusion.message.ParseMessageException;
import com.pushtechnology.diffusion.message.ServiceMessage;
import java.nio.ByteBuffer;

public class MessageToClientParser
implements MessageParser {
    @Override
    public Message parseMessage(byte messageType, MessageEncoding encoding, ByteBuffer buffer) throws ParseMessageException {
        switch (messageType) {
            case 4: 
            case 5: {
                return ClientTopicMessage.parse(messageType, encoding, buffer);
            }
            case 0: {
                return ServiceMessage.parseServiceRequest(buffer);
            }
            case 6: {
                return ServiceMessage.parseServiceResponse(buffer);
            }
            case 1: {
                return ServiceMessage.parseProtocol9ServiceResponse(buffer);
            }
            case 7: {
                return ServiceMessage.parseServiceError(buffer);
            }
            case 2: {
                return ServiceMessage.parseProtocol9ServiceError(buffer);
            }
            case 28: {
                return AbortNotificationMessage.INSTANCE;
            }
        }
        throw new ParseMessageException("Unrecognised message type " + messageType);
    }
}

