/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.http;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class RequestBistable {
    private static final int READY = 0;
    private static final int BUSY = 1;
    private static final int CLOSED = 2;
    private static final AtomicIntegerFieldUpdater<RequestBistable> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RequestBistable.class, "state");
    private volatile int state = 0;

    public boolean setReady() {
        return STATE_UPDATER.compareAndSet(this, 1, 0);
    }

    public boolean setBusy() {
        return STATE_UPDATER.compareAndSet(this, 0, 1);
    }

    public boolean close() {
        return STATE_UPDATER.getAndSet(this, 2) != 2;
    }

    public boolean isBusy() {
        return this.state == 1;
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    public boolean isReady() {
        return this.state == 0;
    }

    public String toString() {
        switch (this.state) {
            case 2: {
                return "[CLOSED]";
            }
            case 1: {
                return "[BUSY]";
            }
            case 0: {
                return "[READY]";
            }
        }
        return "[UNKNOWN]";
    }
}

