/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.http;

import com.pushtechnology.diffusion.comms.http.ChannelCreationConfiguration;
import com.pushtechnology.diffusion.comms.http.NetworkChannelCreator;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.java8.CompletableFutures;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import com.pushtechnology.diffusion.messagechannel.MessageChannelMultiplexerClient;
import com.pushtechnology.diffusion.threads.MultiplexerOnly;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;

public class MultiplexerChannelCreator {
    private static final Logger LOG = I18nLogger.getLogger(MultiplexerChannelCreator.class);
    private static final AtomicReferenceFieldUpdater<MultiplexerChannelCreator, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(MultiplexerChannelCreator.class, State.class, "state");
    private static final State INITIAL_STATE = new State(0);
    private final ChannelCreationConfiguration configuration;
    private final MessageChannelMultiplexerClient executor;
    private volatile State state = INITIAL_STATE;

    MultiplexerChannelCreator(ChannelCreationConfiguration config, MessageChannelMultiplexerClient executor) {
        this.configuration = config;
        this.executor = executor;
    }

    MultiplexerChannelCreator(ChannelCreationConfiguration config, MessageChannelMultiplexerClient executor, NetworkChannel networkChannel) {
        this(config, executor);
        assert (networkChannel.isOpen()) : "NetworkChannel provided was closed";
        this.state = new State(2, networkChannel);
    }

    @MultiplexerOnly
    public CompletableFuture<NetworkChannel> connect() {
        State current = this.state;
        State openingState = new State(1, current.channel);
        if (current.state == 0 && STATE_UPDATER.compareAndSet(this, current, openingState)) {
            CompletableFuture<NetworkChannel> channelCreation = new CompletableFuture<NetworkChannel>();
            NetworkChannelCreator registrar = new NetworkChannelCreator(this.configuration.getNetworkChannelFactory(), this.configuration.getServerDetails(), this.configuration.getNetworkContext(), channelCreation);
            this.executor.dispatchInNonMultiplexerThread(registrar);
            return channelCreation.whenComplete((nc, f) -> {
                if (nc != null) {
                    if (!STATE_UPDATER.compareAndSet(this, openingState, new State(2, (NetworkChannel)nc))) {
                        nc.close();
                        throw new IllegalStateException("Could not transition from OPENING to OPEN");
                    }
                    this.configuration.getNetworkContext().getSelector().registerForInitialRead(this.configuration.getExecutionPool(), this.configuration.getServerDetails().getInputBufferSize(), this.configuration.getInitialHandler(), null);
                } else {
                    STATE_UPDATER.compareAndSet(this, openingState, new State(4, openingState.channel));
                }
            });
        }
        if (current.channel != null) {
            return CompletableFuture.completedFuture(current.channel);
        }
        return CompletableFutures.failedFuture(new IllegalStateException("Aborting connection because channel is in unexpected state:: " + String.valueOf(this)));
    }

    public boolean isConnectionPending() {
        return this.state.state == 1;
    }

    public boolean isConnected() {
        return this.state.state == 2;
    }

    public boolean isConnectedOutbound() {
        State current = this.state;
        return current.state == 2 && !current.channel.isOutputShutdown();
    }

    public boolean isFailed() {
        return this.state.state == 4;
    }

    public void close() {
        LOG.debug("close(): {}", (Object)this);
        State current = this.state;
        while (current.state == 1) {
            current = this.state;
        }
        if (current.state == 2) {
            STATE_UPDATER.compareAndSet(this, current, new State(3, current.channel));
        }
    }

    public void completeClose() {
        LOG.debug("completeClose(): {}", (Object)this);
        State current = this.state;
        if (current.state == 3) {
            STATE_UPDATER.compareAndSet(this, current, new State(0, current.channel));
        }
    }

    public final void shutdown() {
        State current = this.state;
        while (current.state != 4) {
            if ((current.state == 2 || current.state == 3) && STATE_UPDATER.compareAndSet(this, current, new State(0, current.channel))) {
                current.channel.close();
                return;
            }
            current = this.state;
        }
    }

    public final void fail() {
        State current = this.state;
        while (!STATE_UPDATER.compareAndSet(this, current, new State(4, current.channel))) {
            current = this.state;
        }
        if (current.channel != null) {
            current.channel.close();
        }
    }

    public NetworkChannel getChannel() {
        State current = this.state;
        if (current.state == 1 && current.channel == null) {
            throw new IllegalStateException("Channel should not be null but state is " + String.valueOf(current) + " for " + String.valueOf(current.channel) + " " + String.valueOf(this));
        }
        return current.channel;
    }

    public NetworkChannel getChannelToClose() {
        State current = this.state;
        if (current.state == 3 || current.state == 0) {
            return current.channel;
        }
        return null;
    }

    public String toString() {
        return super.toString() + ":" + String.valueOf(this.state);
    }

    @Immutable
    private static final class State {
        private static final int CLOSED = 0;
        private static final int OPENING = 1;
        private static final int OPEN = 2;
        private static final int CLOSING = 3;
        private static final int FAILED = 4;
        private final int state;
        private final NetworkChannel channel;

        private State(int state) {
            this(state, null);
        }

        private State(int state, NetworkChannel channel) {
            this.state = state;
            this.channel = channel;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.state) {
                case 0: {
                    sb.append("[CLOSED]: ").append(this.channel);
                    break;
                }
                case 2: {
                    sb.append("[OPEN]: ").append(this.channel);
                    break;
                }
                case 1: {
                    sb.append("[OPENING]");
                    break;
                }
                case 3: {
                    sb.append("[CLOSING]: ").append(this.channel);
                    break;
                }
                case 4: {
                    sb.append("[FAILED]");
                    break;
                }
                default: {
                    sb.append("[UNKNOWN]");
                }
            }
            return sb.toString();
        }
    }
}

