/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.response;

import com.pushtechnology.diffusion.clients.token.SessionToken;
import com.pushtechnology.diffusion.clients.token.impl.SessionTokenByteBufferDeserialiser;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.AbstractByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.DeserialisationException;
import com.pushtechnology.diffusion.session.impl.SessionIdImpl;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public final class ConnectionResponseDeserialiser
extends AbstractByteBufferDeserialiser {
    private final ByteBufferDeserialiser tokenDeserialiser = new SessionTokenByteBufferDeserialiser();

    @Override
    public Object doRead(ByteBuffer source) throws DeserialisationException {
        ResponseCode responseCode;
        byte protocol = source.get();
        if (protocol != 35) {
            return ByteBufferDeserialiser.DeserialisationResult.UNRECOGNISED;
        }
        byte versionByte = source.get();
        ProtocolVersion version = ProtocolVersion.fromByte(versionByte);
        if (version == ProtocolVersion.UNKNOWN_EARLY_VERSION || version == ProtocolVersion.UNKNOWN_LATER_VERSION) {
            return ByteBufferDeserialiser.DeserialisationResult.UNRECOGNISED;
        }
        try {
            responseCode = ResponseCode.fromByte(source.get());
        }
        catch (IllegalArgumentException e) {
            return ByteBufferDeserialiser.DeserialisationResult.UNRECOGNISED;
        }
        if (responseCode.isSuccess()) {
            int maximumMessageSize;
            int recoverySequence;
            SessionIdImpl sessionId = new SessionIdImpl(source.getLong(), source.getLong());
            Object deserialisedSessionToken = this.tokenDeserialiser.read(source);
            if (ByteBufferDeserialiser.DeserialisationResult.decode(deserialisedSessionToken) == ByteBufferDeserialiser.DeserialisationResult.INSUFFICIENT_DATA) {
                return ByteBufferDeserialiser.DeserialisationResult.INSUFFICIENT_DATA;
            }
            long systemPingPeriod = source.getLong();
            if (responseCode == ResponseCode.RECONNECTED) {
                recoverySequence = source.getInt();
                maximumMessageSize = -1;
            } else {
                recoverySequence = 0;
                maximumMessageSize = version.isAtLeast(ProtocolVersion.PROTOCOL_17_VERSION) ? source.getInt() : -1;
            }
            return new ConnectionResponse(responseCode, sessionId, (SessionToken)ByteBufferDeserialiser.DeserialisationResult.deserialisedValue(deserialisedSessionToken), version, systemPingPeriod, recoverySequence, maximumMessageSize);
        }
        return new ConnectionResponse(responseCode, null, null, version, -1L, 0, -1);
    }
}

