/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.request;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.clients.token.SessionToken;
import com.pushtechnology.diffusion.comms.connection.ConnectionCapabilities;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.request.AbstractConnectRequest;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReconnectionRequest
extends AbstractConnectRequest {
    private final SessionToken token;
    private final int availableClientSequence;
    private final int lastServerSequence;

    public ReconnectionRequest(ProtocolVersion protocolVersion, InternalConnectionType type, ConnectionCapabilities capabilities, SessionToken token, int availableClientSequence, int lastServerSequence) {
        super(protocolVersion, type, capabilities);
        this.token = token;
        this.availableClientSequence = availableClientSequence;
        this.lastServerSequence = lastServerSequence;
    }

    public SessionToken getToken() {
        return this.token;
    }

    public int availableClientSequence() {
        return this.availableClientSequence;
    }

    public int lastServerSequence() {
        return this.lastServerSequence;
    }

    @Override
    public ReconnectionRequest withProtocolVersion(ProtocolVersion requestedVersion) {
        return new ReconnectionRequest(requestedVersion, this.getConnectionType(), this.getCapabilities(), this.getToken(), this.availableClientSequence(), this.lastServerSequence());
    }

    public String toString() {
        return String.format("%s(%s, %s, %s, %s, %d, %d)", new Object[]{this.getClass().getSimpleName(), this.getProtocolVersion(), this.getConnectionType(), this.getCapabilities(), this.token, this.availableClientSequence, this.lastServerSequence});
    }
}

