/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection.request;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.comms.connection.ConnectionCapabilities;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.request.AbstractConnectRequest;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class ConnectionRequest
extends AbstractConnectRequest {
    private final String principal;
    private final Credentials credentials;
    private final Map<String, String> proposedSessionProperties;
    private final int reconnectionTimeout;
    private final String serverUUID;

    public ConnectionRequest(ProtocolVersion protocolVersion, InternalConnectionType type, ConnectionCapabilities capabilities, String principal, Credentials credentials, Map<String, String> proposedSessionProperties, int reconnectionTimeout, String serverUUID) {
        super(protocolVersion, type, capabilities);
        this.principal = principal;
        this.credentials = credentials;
        this.proposedSessionProperties = proposedSessionProperties;
        this.reconnectionTimeout = reconnectionTimeout;
        this.serverUUID = serverUUID;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public Map<String, String> getProposedSessionProperties() {
        return this.proposedSessionProperties;
    }

    public String getServerUUID() {
        return this.serverUUID;
    }

    @Override
    public ConnectionRequest withProtocolVersion(ProtocolVersion requestedVersion) {
        return new ConnectionRequest(requestedVersion, this.getConnectionType(), this.getCapabilities(), this.getPrincipal(), this.getCredentials(), this.getProposedSessionProperties(), this.getReconnectionTimeout(), this.getServerUUID());
    }

    public int getReconnectionTimeout() {
        return this.reconnectionTimeout;
    }

    public String toString() {
        return String.format("%s(%s, %s, %s, %s, %s, %s, %s %s)", new Object[]{this.getClass().getSimpleName(), this.getProtocolVersion(), this.getConnectionType(), this.getCapabilities(), this.getPrincipal(), this.getCredentials(), this.getProposedSessionProperties(), this.getReconnectionTimeout(), this.getServerUUID()});
    }
}

