/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.OutboundHandshakeFactory;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentException;
import com.pushtechnology.diffusion.comms.connection.ClientMessageChannelFactory;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeEventListener;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeResult;
import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactory;
import com.pushtechnology.diffusion.comms.connection.OutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.ReverseSecondaryConnector;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.comms.websocket.MessageToClientParser;
import com.pushtechnology.diffusion.comms.websocket.WebSocketFrameCodec;
import com.pushtechnology.diffusion.comms.websocket.WebSocketMessageChannel;
import com.pushtechnology.diffusion.comms.websocket.WebSocketOutboundHandshake;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.messagechannel.ws.WebSocketMessageDeserialiser;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReverseSecondaryConnectorImpl
implements ReverseSecondaryConnector,
Startable {
    private final NetworkChannelFactory theNetworkChannelFactory;
    private final ClientMessageChannelFactory theMessageChannelFactory;
    private final OutboundHandshakeFactory theHandshakeFactory;
    private final CommonThreadPools theThreadPools;
    private volatile ScheduledExecutorService theBackgroundThreadPool;

    public ReverseSecondaryConnectorImpl(NetworkChannelFactory networkChannelFactory, CommonThreadPools threadPools) {
        this(networkChannelFactory, (response, networkChannel, serverDetails, connectionType, connectionCapabilities, multiplexerClient, messageChannelListener, maximumMessageSize) -> new WebSocketMessageChannel(networkChannel, new ConnectionInfo(connectionType, connectionCapabilities, response.getProtocolVersion(), Integer.MAX_VALUE), new WebSocketFrameCodec(new WebSocketMessageDeserialiser(new MessageToClientParser()), maximumMessageSize, true), serverDetails.getOutputBufferSize(), multiplexerClient, messageChannelListener), WebSocketOutboundHandshake.FACTORY, threadPools);
    }

    ReverseSecondaryConnectorImpl(NetworkChannelFactory networkChannelFactory, ClientMessageChannelFactory messageChannelFactory, OutboundHandshakeFactory handshakeFactory, CommonThreadPools threadPools) {
        this.theNetworkChannelFactory = networkChannelFactory;
        this.theMessageChannelFactory = messageChannelFactory;
        this.theThreadPools = threadPools;
        this.theHandshakeFactory = handshakeFactory;
    }

    @Override
    public void start() {
        this.theBackgroundThreadPool = this.theThreadPools.getBackgroundThreadPool();
    }

    @Override
    public void stop() {
    }

    @Override
    public ConnectionHandshakeResult connect(NetworkChannel networkChannel, ServerDetails serverDetails, NetworkContext networkContext, ConnectionRequest connectionRequest, ConnectionHandshakeEventListener listener, int maximumMessageSize) throws IOException {
        DirectByteBufferPool buffers = networkContext.getBufferPool();
        ByteBuffer initialBuffer = buffers.provide(serverDetails.getInputBufferSize());
        try {
            NetworkChannel channel = this.theNetworkChannelFactory.createReverseChannel(serverDetails, initialBuffer, networkChannel);
            listener.onConnectionAttempt(serverDetails.getTransport());
            OutboundHandshake handshake = this.theHandshakeFactory.create(serverDetails, maximumMessageSize, this.theBackgroundThreadPool);
            ConnectionResponse connectionResponse = handshake.connect(channel, connectionRequest, initialBuffer);
            ResponseCode responseCode = connectionResponse.getCode();
            if (!responseCode.isSuccess()) {
                throw new SessionEstablishmentException("Reverse client connection failed with " + String.valueOf((Object)responseCode));
            }
            listener.onConnection();
            return new ConnectionHandshakeResult(channel, initialBuffer, connectionResponse, serverDetails, this.theMessageChannelFactory);
        }
        catch (Exception ex) {
            buffers.release(initialBuffer);
            networkChannel.close();
            listener.onFatalConnectionException();
            throw ex;
        }
    }

    ClientMessageChannelFactory getMessageChannelFactory() {
        return this.theMessageChannelFactory;
    }
}

