/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.OutboundHandshakeFactory;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactory;
import com.pushtechnology.diffusion.comms.connection.OutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import com.pushtechnology.diffusion.comms.connection.ReversePrimaryConnectionResult;
import com.pushtechnology.diffusion.comms.connection.ReversePrimaryConnector;
import com.pushtechnology.diffusion.comms.connection.request.ReverseConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.comms.websocket.WebSocketOutboundHandshake;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReversePrimaryConnectorImpl
implements ReversePrimaryConnector {
    private final NetworkChannelFactory theNetworkChannelFactory;
    private final OutboundHandshakeFactory theOutboundHandshakeFactory;
    private final CommonThreadPools theThreadPools;

    public ReversePrimaryConnectorImpl(CommonThreadPools threadPools, NetworkChannelFactory networkChannelFactory) {
        this(threadPools, networkChannelFactory, WebSocketOutboundHandshake.FACTORY);
    }

    ReversePrimaryConnectorImpl(CommonThreadPools threadPools, NetworkChannelFactory networkChannelFactory, OutboundHandshakeFactory handshakeFactory) {
        this.theThreadPools = threadPools;
        this.theNetworkChannelFactory = networkChannelFactory;
        this.theOutboundHandshakeFactory = handshakeFactory;
    }

    @Override
    public ReversePrimaryConnectionResult connect(String remoteServerName, String requestId, String serverUUID, ServerDetails serverDetails, NetworkContext networkContext, int maximumMessageSize) throws IOException {
        DirectByteBufferPool buffers = networkContext.getBufferPool();
        ByteBuffer initialBuffer = buffers.provide(serverDetails.getInputBufferSize());
        try {
            return this.doConnect(remoteServerName, requestId, serverUUID, serverDetails, networkContext, maximumMessageSize, initialBuffer);
        }
        catch (IOException ex) {
            buffers.release(initialBuffer);
            throw ex;
        }
        catch (Throwable ex) {
            buffers.release(initialBuffer);
            throw new ConnectionException("Reverse connection exception", ex);
        }
    }

    private ReversePrimaryConnectionResult doConnect(String remoteServerName, String requestId, String serverUUID, ServerDetails serverDetails, NetworkContext networkContext, int maximumMessageSize, ByteBuffer initialBuffer) throws IOException {
        NetworkChannel networkChannel = this.theNetworkChannelFactory.createChannel(serverDetails, initialBuffer, networkContext);
        try {
            OutboundHandshake handshake = this.theOutboundHandshakeFactory.create(serverDetails, maximumMessageSize, this.theThreadPools.getBackgroundThreadPool());
            ReverseConnectionRequest request = new ReverseConnectionRequest(remoteServerName, requestId, serverUUID, ProtocolVersion.CURRENT_VERSION);
            ConnectionResponse connectionResponse = handshake.reverseConnect(networkChannel, request, initialBuffer);
            ResponseCode responseCode = connectionResponse.getCode();
            if (responseCode != ResponseCode.REVERSE_CONNECTION_ACCEPTED) {
                throw new ConnectionException("Reverse connection to " + String.valueOf(serverDetails) + " has failed with " + String.valueOf((Object)responseCode));
            }
        }
        catch (Throwable ex) {
            networkChannel.close();
            throw ex;
        }
        return new ReversePrimaryConnectionResult(networkChannel, initialBuffer, serverDetails);
    }
}

