/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.CascadeDriver;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeEventListener;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeResult;
import com.pushtechnology.diffusion.comms.connection.NetworkContextPool;
import com.pushtechnology.diffusion.comms.connection.OutboundConnection;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionCallbacks;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionFactory;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionFactoryParameters;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionImpl;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionMessageHandler;
import com.pushtechnology.diffusion.comms.connection.OutboundConnectionParameters;
import com.pushtechnology.diffusion.comms.connection.ReconnectionParameters;
import com.pushtechnology.diffusion.comms.connection.ReverseSecondaryConnector;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.flowcontrol.FlowControl;
import com.pushtechnology.diffusion.flowcontrol.FlowControlBuilder;
import com.pushtechnology.diffusion.flowcontrol.PendingOperationsImpl;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.messagequeue.ClientOutboundMessageQueueFactory;
import com.pushtechnology.diffusion.messagequeue.OutboundMessageQueue;
import com.pushtechnology.diffusion.messagequeue.OutboundQueueConfiguration;
import com.pushtechnology.diffusion.multiplexer.Multiplexer;
import com.pushtechnology.diffusion.multiplexer.MultiplexerSource;
import com.pushtechnology.diffusion.multiplexer.messageclient.MultiplexerFlowMeasurement;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jcip.annotations.Immutable;

@Immutable
public final class OutboundConnectionFactoryImpl
implements OutboundConnectionFactory {
    private final ClientOutboundMessageQueueFactory messageQueueFactory;
    private final FlowControlBuilder flowControlBuilder;
    private final MultiplexerSource<?> multiplexerSource;
    private final OutboundConnectionFactoryParameters factoryParameters;

    public static OutboundConnectionFactoryImpl createOutboundConnectionFactory(NetworkContextPool networkContexts, MultiplexerSource<?> multiplexerSource, ClientOutboundMessageQueueFactory messageQueueFactory, FlowControlBuilder flowControlBuilder, ExecutionPool inboundExecutionPool, CascadeDriver cascadeDriver, ReverseSecondaryConnector reverseSecondaryConnector, int maximumMessageSize) {
        OutboundConnectionFactoryParameters factoryParameters = new OutboundConnectionFactoryParameters(inboundExecutionPool, networkContexts, maximumMessageSize, cascadeDriver, reverseSecondaryConnector);
        return new OutboundConnectionFactoryImpl(multiplexerSource, messageQueueFactory, flowControlBuilder, factoryParameters);
    }

    OutboundConnectionFactoryImpl(MultiplexerSource<?> multiplexerSource, ClientOutboundMessageQueueFactory messageQueueFactory, FlowControlBuilder flowControlBuilder, OutboundConnectionFactoryParameters factoryParameters) {
        this.multiplexerSource = multiplexerSource;
        this.messageQueueFactory = messageQueueFactory;
        this.flowControlBuilder = flowControlBuilder;
        this.factoryParameters = factoryParameters;
    }

    @Override
    public OutboundConnectionFactory.PendingConnection connectMessageChannel(List<ServerDetails> serverDetailsList, ConnectionRequest connectionRequest, ConnectionHandshakeEventListener handshakeEventListener) throws IOException {
        NetworkContext networkContext = this.factoryParameters.getNetworkContexts().next();
        return new PendingConnectionImpl(this.factoryParameters.getCascadeDriver().connect(serverDetailsList, networkContext, connectionRequest, handshakeEventListener, this.factoryParameters.getMaximumMessageSize()), networkContext, connectionRequest, serverDetailsList, handshakeEventListener);
    }

    @Override
    public OutboundConnectionFactory.PendingConnection connectReverseMessageChannel(ServerDetails serverDetails, ConnectionRequest connectionRequest, ConnectionHandshakeEventListener handshakeEventListener, NetworkChannel networkChannel) throws IOException {
        NetworkContext networkContext = networkChannel.networkContext();
        return new PendingConnectionImpl(this.factoryParameters.getReverseSecondaryConnector().connect(networkChannel, serverDetails, networkContext, connectionRequest, handshakeEventListener, this.factoryParameters.getMaximumMessageSize()), networkContext, connectionRequest);
    }

    private final class PendingConnectionImpl
    implements OutboundConnectionFactory.PendingConnection {
        private final AtomicBoolean created;
        private final ConnectionHandshakeResult handshakeResult;
        private final NetworkContext networkContext;
        private final ConnectionRequest connectionRequest;
        private final List<ServerDetails> serverDetailsList;
        private final ConnectionHandshakeEventListener connectionHandshakeEventListener;

        private PendingConnectionImpl(ConnectionHandshakeResult handshakeResult, NetworkContext networkContext, ConnectionRequest connectionRequest, List<ServerDetails> serverDetailsList, ConnectionHandshakeEventListener connectionHandshakeEventListener) {
            this.handshakeResult = handshakeResult;
            this.networkContext = networkContext;
            this.connectionRequest = connectionRequest;
            this.serverDetailsList = serverDetailsList;
            this.connectionHandshakeEventListener = connectionHandshakeEventListener;
            this.created = new AtomicBoolean(false);
        }

        private PendingConnectionImpl(ConnectionHandshakeResult handshakeResult, NetworkContext networkContext, ConnectionRequest connectionRequest) {
            this(handshakeResult, networkContext, connectionRequest, null, null);
        }

        @Override
        public ConnectionResponse getResponse() {
            return this.handshakeResult.getConnectionResponse();
        }

        @Override
        public OutboundConnection createConnection(OutboundQueueConfiguration outboundQueueConfiguration, int recoveryBufferSize, OutboundConnectionCallbacks connectionCallbacks, OutboundConnectionMessageHandler handler, Object inboundThreadKey) {
            if (!this.created.compareAndSet(false, true)) {
                throw new IllegalStateException("The connection has already been created");
            }
            ConnectionResponse response = this.handshakeResult.getConnectionResponse();
            OutboundMessageQueue messageQueue = OutboundConnectionFactoryImpl.this.messageQueueFactory.create(outboundQueueConfiguration);
            PendingOperationsImpl pendingOperations = new PendingOperationsImpl();
            FlowControl flowControl = OutboundConnectionFactoryImpl.this.flowControlBuilder.with(new MultiplexerFlowMeasurement(messageQueue, pendingOperations)).build();
            OutboundConnectionImpl connection = new OutboundConnectionImpl((Multiplexer)OutboundConnectionFactoryImpl.this.multiplexerSource.nextMultiplexer(), messageQueue, flowControl, pendingOperations, OutboundConnectionFactoryImpl.this.factoryParameters, new OutboundConnectionParameters(this.handshakeResult.getServerDetails(), this.connectionRequest.getReconnectionTimeout(), handler, connectionCallbacks), this.serverDetailsList != null ? new ReconnectionParameters(this.serverDetailsList, this.connectionHandshakeEventListener, this.connectionRequest.getConnectionType(), this.connectionRequest.getCapabilities()) : null, response, recoveryBufferSize, inboundThreadKey);
            connection.completeConnection(this.connectionRequest, this.handshakeResult, this.networkContext.getSelector(), r -> {});
            return connection;
        }
    }
}

