/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.InternalConnectionType;
import com.pushtechnology.diffusion.comms.connection.ConnectionCapabilities;
import com.pushtechnology.diffusion.comms.connection.ProtocolVersion;
import net.jcip.annotations.Immutable;

@Immutable
public final class ConnectionInfo {
    private final InternalConnectionType connectionType;
    private final ConnectionCapabilities capabilities;
    private final ProtocolVersion protocolVersion;
    private final int clientProposedReconnectTime;
    private final ConnectionInfo withoutCompression;

    public ConnectionInfo(InternalConnectionType connectionType, ConnectionCapabilities capabilities, ProtocolVersion protocolVersion, int clientProposedReconnectTime) {
        this.connectionType = connectionType;
        this.capabilities = capabilities;
        this.protocolVersion = protocolVersion;
        this.clientProposedReconnectTime = clientProposedReconnectTime;
        this.withoutCompression = capabilities.supportsZlibCompression() ? new ConnectionInfo(connectionType, capabilities.withoutZlibCompression(), protocolVersion, clientProposedReconnectTime) : this;
    }

    public InternalConnectionType getConnectionType() {
        return this.connectionType;
    }

    public ConnectionCapabilities getCapabilities() {
        return this.capabilities;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getClientProposedReconnectTime() {
        return this.clientProposedReconnectTime;
    }

    public ConnectionInfo withoutCompression() {
        return this.withoutCompression;
    }

    public int hashCode() {
        int prime = 31;
        int result = this.capabilities.hashCode();
        result = 31 * result + this.connectionType.hashCode();
        result = 31 * result + this.protocolVersion.hashCode();
        result = 31 * result + this.clientProposedReconnectTime;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo other = (ConnectionInfo)o;
        return this.connectionType == other.connectionType && this.protocolVersion == other.protocolVersion && this.capabilities.equals(other.capabilities) && this.clientProposedReconnectTime == other.clientProposedReconnectTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Type=").append(this.connectionType.getDisplayName()).append(", Version=").append((Object)this.protocolVersion).append(", Capabilities=(").append(this.capabilities).append(", Client Reconnect Time=(").append(this.clientProposedReconnectTime).append(')');
        return sb.toString();
    }
}

