/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import net.jcip.annotations.Immutable;

@Immutable
public final class ConnectionCapabilities {
    private static final byte CAPABILITY_ZLIB = 2;
    private static final byte CAPABILITY_UNIFIED = 8;
    public static final ConnectionCapabilities NO_CAPABILITIES = new ConnectionCapabilities(0);
    public static final ConnectionCapabilities UNIFIED_ALL_CAPABILITIES = new ConnectionCapabilities(10);
    private final byte capabilitiesByte;

    public static ConnectionCapabilities fromByte(byte capabilitiesByte) {
        return new ConnectionCapabilities(capabilitiesByte);
    }

    private ConnectionCapabilities(int capabilitiesByte) {
        this.capabilitiesByte = (byte)capabilitiesByte;
    }

    public ConnectionCapabilities withoutZlibCompression() {
        return this.supportsZlibCompression() ? new ConnectionCapabilities(this.asByte() & 0xFFFFFFFD) : this;
    }

    public boolean supportsZlibCompression() {
        return (this.capabilitiesByte & 2) != 0;
    }

    public byte asByte() {
        return this.capabilitiesByte;
    }

    public String toString() {
        return "ZLIB=" + this.supportsZlibCompression();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != ConnectionCapabilities.class) {
            return false;
        }
        ConnectionCapabilities other = (ConnectionCapabilities)o;
        return other.capabilitiesByte == this.capabilitiesByte;
    }

    public int hashCode() {
        return this.capabilitiesByte;
    }
}

