/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.OutboundHandshakeFactory;
import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.client.session.SessionAttributes;
import com.pushtechnology.diffusion.client.session.SessionEstablishmentException;
import com.pushtechnology.diffusion.client.session.SessionException;
import com.pushtechnology.diffusion.comms.connection.CascadeDriver;
import com.pushtechnology.diffusion.comms.connection.ClientMessageChannelFactory;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeEventListener;
import com.pushtechnology.diffusion.comms.connection.ConnectionHandshakeResult;
import com.pushtechnology.diffusion.comms.connection.ConnectionInfo;
import com.pushtechnology.diffusion.comms.connection.NetworkChannelFactory;
import com.pushtechnology.diffusion.comms.connection.NetworkContextPool;
import com.pushtechnology.diffusion.comms.connection.OutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.request.ConnectOrReconnectRequest;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReconnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.comms.connection.response.ResponseCode;
import com.pushtechnology.diffusion.comms.http.PollingClientMessageChannel;
import com.pushtechnology.diffusion.comms.http.PollingClientOutboundHandshake;
import com.pushtechnology.diffusion.comms.websocket.MessageToClientParser;
import com.pushtechnology.diffusion.comms.websocket.WebSocketFrameCodec;
import com.pushtechnology.diffusion.comms.websocket.WebSocketMessageChannel;
import com.pushtechnology.diffusion.comms.websocket.WebSocketOutboundHandshake;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.io.nio.NetworkContext;
import com.pushtechnology.diffusion.messagechannel.ws.WebSocketMessageDeserialiser;
import com.pushtechnology.diffusion.util.concurrent.threads.CommonThreadPools;
import com.pushtechnology.diffusion.util.concurrent.threads.ExecutionPool;
import com.pushtechnology.diffusion.utils.bytebuffer.DirectByteBufferPool;
import com.pushtechnology.repackaged.picocontainer.Startable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import net.jcip.annotations.Immutable;

@Immutable
public final class CascadeDriverImpl
implements CascadeDriver,
Startable {
    private final NetworkChannelFactory networkChannelFactory;
    private final Map<SessionAttributes.Transport, ClientMessageChannelFactory> messageChannelFactories;
    private final OutboundHandshakeFactory handshakeFactory;
    private final CommonThreadPools threadPools;
    private volatile ScheduledExecutorService backgroundThreadPool;

    public CascadeDriverImpl(CommonThreadPools threadPools, NetworkContextPool networkContexts, NetworkChannelFactory networkChannelFactory) {
        this.threadPools = threadPools;
        this.networkChannelFactory = networkChannelFactory;
        this.messageChannelFactories = CascadeDriverImpl.createMessageChannelFactories(new MessageToClientParser(), networkChannelFactory, networkContexts, threadPools);
        this.handshakeFactory = CascadeDriverImpl::compositeHandshakeFactory;
    }

    CascadeDriverImpl(NetworkChannelFactory networkChannelFactory, Map<SessionAttributes.Transport, ClientMessageChannelFactory> messageChannelFactories, CommonThreadPools threadPools, OutboundHandshakeFactory handshakeFactory) {
        this.networkChannelFactory = networkChannelFactory;
        this.messageChannelFactories = messageChannelFactories;
        this.threadPools = threadPools;
        this.handshakeFactory = handshakeFactory;
    }

    @Override
    public void start() {
        this.backgroundThreadPool = this.threadPools.getBackgroundThreadPool();
    }

    @Override
    public void stop() {
    }

    @Override
    public ConnectionHandshakeResult connect(List<? extends ServerDetails> serverDetailsList, NetworkContext networkContext, ConnectionRequest connectionRequest, ConnectionHandshakeEventListener listener, int maximumMessageSize) throws IOException {
        return this.beginCascade((initialBuffer, channel, handshake, request) -> handshake.connect(channel, (ConnectionRequest)request, initialBuffer), serverDetailsList, networkContext, listener, maximumMessageSize, connectionRequest);
    }

    @Override
    public ConnectionHandshakeResult reconnect(List<? extends ServerDetails> serverDetailsList, NetworkContext networkContext, ReconnectionRequest reconnectionRequest, ConnectionHandshakeEventListener listener, int maximumMessageSize) throws IOException {
        return this.beginCascade((initialBuffer, channel, handshake, request) -> handshake.reconnect(channel, (ReconnectionRequest)request, initialBuffer), serverDetailsList, networkContext, listener, maximumMessageSize, reconnectionRequest);
    }

    private ConnectionHandshakeResult beginCascade(PerformHandshake performHandshake, List<? extends ServerDetails> serverDetailsList, NetworkContext networkContext, ConnectionHandshakeEventListener listener, int maximumMessageSize, ConnectOrReconnectRequest request) throws IOException {
        assert (!serverDetailsList.isEmpty()) : "At least one server details must be provided to allocate the buffer";
        DirectByteBufferPool buffers = networkContext.getBufferPool();
        ByteBuffer initialBuffer = buffers.provide(serverDetailsList.get(0).getInputBufferSize());
        try {
            return this.cascade(performHandshake, serverDetailsList, networkContext, listener, initialBuffer, maximumMessageSize, request);
        }
        catch (Exception e) {
            buffers.release(initialBuffer);
            throw e;
        }
    }

    private ConnectionHandshakeResult cascade(PerformHandshake performHandshake, List<? extends ServerDetails> serverDetailsList, NetworkContext networkContext, ConnectionHandshakeEventListener listener, ByteBuffer initialBuffer, int maximumMessageSize, ConnectOrReconnectRequest request) throws IOException {
        IOException lastException = null;
        for (ServerDetails serverDetails : serverDetailsList) {
            NetworkChannel channel;
            SessionAttributes.Transport transport = serverDetails.getTransport();
            listener.onConnectionAttempt(transport);
            try {
                channel = this.networkChannelFactory.createChannel(serverDetails, initialBuffer, networkContext);
            }
            catch (IOException e) {
                initialBuffer.clear();
                lastException = e;
                continue;
            }
            OutboundHandshake handshake = this.handshakeFactory.create(serverDetails, maximumMessageSize, this.backgroundThreadPool);
            ClientMessageChannelFactory messageChannelFactory = this.messageChannelFactories.get((Object)transport);
            try {
                ConnectionResponse connectionResult = performHandshake.performHandshake(initialBuffer, channel, handshake, request);
                if (connectionResult.getCode() == ResponseCode.DOWNGRADE) {
                    channel.close();
                    initialBuffer.clear();
                    channel = this.networkChannelFactory.createChannel(serverDetails, initialBuffer, networkContext);
                    connectionResult = performHandshake.performHandshake(initialBuffer, channel, handshake, request.withProtocolVersion(connectionResult.getProtocolVersion()));
                }
                if (connectionResult.getCode() == ResponseCode.DOWNGRADE) {
                    throw new SessionEstablishmentException("Connection downgrade failed.");
                }
                listener.onConnection();
                return new ConnectionHandshakeResult(channel, initialBuffer, connectionResult, serverDetails, messageChannelFactory);
            }
            catch (SessionException e) {
                listener.onFatalConnectionException();
                channel.close();
                throw e;
            }
            catch (IOException e) {
                channel.close();
                initialBuffer.clear();
                lastException = e;
            }
        }
        listener.onTransportsExhausted();
        throw lastException;
    }

    private static Map<SessionAttributes.Transport, ClientMessageChannelFactory> createMessageChannelFactories(MessageToClientParser messageParser, NetworkChannelFactory networkChannelFactory, NetworkContextPool networkContexts, CommonThreadPools threadPools) {
        EnumMap<SessionAttributes.Transport, ClientMessageChannelFactory> messageChannelFactoryMap = new EnumMap<SessionAttributes.Transport, ClientMessageChannelFactory>(SessionAttributes.Transport.class);
        messageChannelFactoryMap.put(SessionAttributes.Transport.WEBSOCKET, (response, networkChannel, serverDetails, connectionType, connectionCapabilities, multiplexerClient, messageChannelListener, maximumMessageSize) -> {
            WebSocketFrameCodec messageDeserialiser = new WebSocketFrameCodec(new WebSocketMessageDeserialiser(messageParser), maximumMessageSize, true);
            return new WebSocketMessageChannel(networkChannel, new ConnectionInfo(connectionType, connectionCapabilities, response.getProtocolVersion(), Integer.MAX_VALUE), messageDeserialiser, serverDetails.getOutputBufferSize(), multiplexerClient, messageChannelListener);
        });
        messageChannelFactoryMap.put(SessionAttributes.Transport.HTTP_POLLING, (response, networkChannel, serverDetails, connectionType, connectionCapabilities, multiplexerClient, messageChannelListener, maximumMessageSize) -> {
            ExecutionPool inboundThreadPool = threadPools.getDefaultInboundThreadPool();
            return PollingClientMessageChannel.createPollingClientMessageChannel(maximumMessageSize, networkContexts.next(), new ConnectionInfo(connectionType, connectionCapabilities, response.getProtocolVersion(), Integer.MAX_VALUE), networkChannel, networkChannelFactory, messageParser, response.getSessionToken(), serverDetails, inboundThreadPool, multiplexerClient, messageChannelListener);
        });
        return messageChannelFactoryMap;
    }

    private static OutboundHandshake compositeHandshakeFactory(ServerDetails serverDetails, int maximumMessageSize, ScheduledExecutorService backgroundThreadPool) {
        SessionAttributes.Transport transport = serverDetails.getTransport();
        return (switch (transport) {
            case SessionAttributes.Transport.HTTP_POLLING -> PollingClientOutboundHandshake.FACTORY;
            case SessionAttributes.Transport.WEBSOCKET -> WebSocketOutboundHandshake.FACTORY;
            default -> throw new IllegalArgumentException("Unsupported transport: " + String.valueOf((Object)transport));
        }).create(serverDetails, maximumMessageSize, backgroundThreadPool);
    }

    private static interface PerformHandshake {
        public ConnectionResponse performHandshake(ByteBuffer var1, NetworkChannel var2, OutboundHandshake var3, ConnectOrReconnectRequest var4) throws IOException;
    }
}

