/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.OutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.io.ByteSource;
import com.pushtechnology.diffusion.io.bytebuffer.serialisation.ByteBufferDeserialiser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractOutboundHandshake
implements OutboundHandshake {
    private final ScheduledExecutorService backgroundThreadPool;
    private final ServerDetails serverDetails;

    protected AbstractOutboundHandshake(ServerDetails serverDetails, ScheduledExecutorService backgroundThreadPool) {
        this.serverDetails = serverDetails;
        this.backgroundThreadPool = backgroundThreadPool;
    }

    protected final ServerDetails getServerDetails() {
        return this.serverDetails;
    }

    protected final ConnectionResponse readConnectionResponse(ByteSource channel, ByteBuffer buffer, ByteBufferDeserialiser responseDeserialiser) throws IOException {
        int beginningOfData = buffer.position();
        while (true) {
            Object response;
            int endOfData = buffer.limit();
            if (buffer.hasRemaining() && ByteBufferDeserialiser.DeserialisationResult.decode(response = responseDeserialiser.read(buffer)) != ByteBufferDeserialiser.DeserialisationResult.INSUFFICIENT_DATA) {
                ConnectionResponse ret = (ConnectionResponse)ByteBufferDeserialiser.DeserialisationResult.deserialisedValue(response);
                ret.getCode().checkSuccess();
                return ret;
            }
            buffer.position(endOfData);
            buffer.limit(buffer.capacity());
            int result = this.readWithTimeout(channel, buffer);
            if (result == -1) {
                throw new ConnectionException("EOF before response read");
            }
            buffer.limit(buffer.position());
            buffer.position(beginningOfData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int readWithTimeout(ByteSource channel, ByteBuffer buffer) throws IOException {
        ScheduledFuture<?> future = this.backgroundThreadPool.schedule(channel::close, this.serverDetails.getConnectionTimeout(), TimeUnit.MILLISECONDS);
        try {
            int n = channel.read(buffer);
            return n;
        }
        finally {
            future.cancel(true);
        }
    }
}

