/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.comms.connection;

import com.pushtechnology.diffusion.api.internal.connection.ServerDetails;
import com.pushtechnology.diffusion.clients.token.SessionToken;
import com.pushtechnology.diffusion.comms.connection.AbstractOutboundHandshake;
import com.pushtechnology.diffusion.comms.connection.ConnectionException;
import com.pushtechnology.diffusion.comms.connection.request.ConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReconnectionRequest;
import com.pushtechnology.diffusion.comms.connection.request.ReverseConnectionRequest;
import com.pushtechnology.diffusion.comms.connection.response.ConnectionResponse;
import com.pushtechnology.diffusion.http.HTTPConstants;
import com.pushtechnology.diffusion.http.HTTPHeaders;
import com.pushtechnology.diffusion.http.URIEncoder;
import com.pushtechnology.diffusion.io.ByteSink;
import com.pushtechnology.diffusion.io.ByteSource;
import com.pushtechnology.diffusion.io.nio.NetworkChannel;
import com.pushtechnology.diffusion.utils.FastEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.ScheduledExecutorService;

public abstract class AbstractHTTPOutboundHandshake
extends AbstractOutboundHandshake {
    protected AbstractHTTPOutboundHandshake(ServerDetails serverDetails, ScheduledExecutorService backgroundThreadPool) {
        super(serverDetails, backgroundThreadPool);
    }

    @Override
    public final ConnectionResponse connect(NetworkChannel channel, ConnectionRequest request, ByteBuffer initialBuffer) throws IOException {
        this.sendConnectRequest(channel, request);
        return this.processResponse(channel, initialBuffer);
    }

    @Override
    public final ConnectionResponse reconnect(NetworkChannel channel, ReconnectionRequest request, ByteBuffer initialBuffer) throws IOException {
        this.sendReconnectRequest(channel, request);
        return this.processResponse(channel, initialBuffer);
    }

    @Override
    public final ConnectionResponse reverseConnect(NetworkChannel channel, ReverseConnectionRequest request, ByteBuffer initialBuffer) throws IOException {
        this.sendReverseConnectRequest(channel, request);
        return this.processResponse(channel, initialBuffer);
    }

    protected abstract void sendConnectRequest(ByteSink var1, ConnectionRequest var2) throws IOException;

    protected abstract void sendReconnectRequest(ByteSink var1, ReconnectionRequest var2) throws IOException;

    protected abstract void sendReverseConnectRequest(ByteSink var1, ReverseConnectionRequest var2) throws IOException;

    protected abstract ConnectionResponse processResponse(NetworkChannel var1, ByteBuffer var2) throws IOException;

    protected final HTTPHeaders readHttpHeaders(ByteSource channel, ByteBuffer buffer) throws IOException {
        int read;
        do {
            buffer.flip();
            HTTPHeaders headers = HTTPHeaders.parseBuffer(buffer);
            if (headers != null) {
                return headers;
            }
            buffer.limit(buffer.capacity());
        } while ((read = this.readWithTimeout(channel, buffer)) != -1);
        throw new ConnectionException("Unable to read HTTP response headers", new ClosedChannelException());
    }

    protected static void encodeHeader(OutputStream out, byte[] key, String value) throws IOException {
        out.write(key);
        out.write(HTTPConstants.COLON_SPACE_BYTES);
        FastEncoder.asciiEncode(value, out);
        out.write(HTTPConstants.CRLF);
    }

    protected static void percentEncodeHeader(OutputStream out, byte[] key, String value) throws IOException {
        out.write(key);
        out.write(HTTPConstants.COLON_SPACE_BYTES);
        URIEncoder.percentEncode(value, out);
        out.write(HTTPConstants.CRLF);
    }

    protected static void encodeHeader(OutputStream out, byte[] key, int value) throws IOException {
        AbstractHTTPOutboundHandshake.encodeHeader(out, key, Integer.toString(value));
    }

    protected static void encodeSessionToken(OutputStream out, SessionToken sessionToken) throws IOException {
        out.write(HTTPConstants.SESSION_TOKEN_HEADER_BYTES);
        out.write(HTTPConstants.COLON_SPACE_BYTES);
        sessionToken.toBytes().copyTo(out);
        out.write(HTTPConstants.CRLF);
    }
}

