/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.receiver;

import com.pushtechnology.diffusion.client.callbacks.ErrorReason;
import com.pushtechnology.diffusion.command.receiver.CommandService;
import com.pushtechnology.diffusion.logs.i18n.I18nLogger;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;

@ThreadSafe
public final class LoggingCommandService<C, R, S>
implements CommandService<C, R, S> {
    private static final Logger LOG = I18nLogger.getLogger(LoggingCommandService.class);
    private final CommandService<C, R, S> service;

    public static <C, R, S> LoggingCommandService<C, R, S> create(CommandService<C, R, S> service) {
        return new LoggingCommandService<C, R, S>(service);
    }

    private LoggingCommandService(CommandService<C, R, S> service) {
        this.service = Objects.requireNonNull(service, "Delegate service cannot be null");
    }

    @Override
    public void onRequest(S session, C command, CommandService.ServiceCallback<R> callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Has received a request {} from {}", this.service, command, session);
            this.service.onRequest(session, command, new LoggingCallback(callback, session));
        } else {
            this.service.onRequest(session, command, callback);
        }
    }

    public String toString() {
        return this.service.toString();
    }

    @ThreadSafe
    private final class LoggingCallback
    implements CommandService.ServiceCallback<R> {
        private final CommandService.ServiceCallback<R> callback;
        private final S session;

        LoggingCallback(CommandService.ServiceCallback<R> callback, S session) {
            this.callback = callback;
            this.session = session;
        }

        @Override
        public void respond(R response) {
            LOG.debug("{}: Responding to {} with {}", LoggingCommandService.this.service, this.session, response);
            this.callback.respond(response);
        }

        @Override
        public void fail(ErrorReason errorReason, String message) {
            LOG.debug("CMD_SERVICE_LOGGER_COMMAND_ERROR", LoggingCommandService.this.service, this.session, errorReason, message);
            this.callback.fail(errorReason, message);
        }

        public String toString() {
            return this.callback.toString();
        }
    }
}

