/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.sessionfetch;

import com.pushtechnology.diffusion.collections.ImmutableSet;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQuery;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-fetch-query", valueType=SessionFetchQuery.class)
public final class SessionFetchQuerySerialiser
extends AbstractSerialiser<SessionFetchQuery> {
    @Override
    public void write(OutputStream out, SessionFetchQuery query) throws IOException {
        EncodedDataCodec.writeString(out, query.getFilter());
        Set<String> properties = query.getRequestedProperties();
        if (properties == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            SessionFetchQuerySerialiser.writeStrings(out, properties);
        }
        Instant from = query.getFrom();
        if (from.equals(SessionFetchQuery.DEFAULT_FROM)) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeInt64(out, from.toEpochMilli());
        }
        Instant to = query.getTo();
        if (to.equals(SessionFetchQuery.DEFAULT_TO)) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeInt64(out, to.toEpochMilli());
        }
        int limit = query.getLimit();
        if (limit == Integer.MAX_VALUE) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeInt32(out, limit);
        }
        EncodedDataCodec.writeInt32(out, query.getMaximumResultSize());
        EncodedDataCodec.writeBoolean(out, query.requiresStartTime());
    }

    @Override
    protected SessionFetchQuery readUnchecked(InputStream in) throws IOException {
        String filter = EncodedDataCodec.readString(in);
        byte propertiesOption = EncodedDataCodec.readByte(in);
        ImmutableSet<String> requestedProperties = propertiesOption == 0 ? null : ImmutableSet.from(SessionFetchQuerySerialiser.readStrings(in));
        byte fromOption = EncodedDataCodec.readByte(in);
        Instant from = fromOption == 0 ? SessionFetchQuery.DEFAULT_FROM : Instant.ofEpochMilli(EncodedDataCodec.readInt64(in));
        byte toOption = EncodedDataCodec.readByte(in);
        Instant to = toOption == 0 ? SessionFetchQuery.DEFAULT_TO : Instant.ofEpochMilli(EncodedDataCodec.readInt64(in));
        byte limitOption = EncodedDataCodec.readByte(in);
        int limit = limitOption == 0 ? Integer.MAX_VALUE : EncodedDataCodec.readInt32(in);
        int maximumResultSize = EncodedDataCodec.readInt32(in);
        boolean requiresStartTime = EncodedDataCodec.readBoolean(in);
        return new SessionFetchQuery(filter, requestedProperties, from, to, limit, maximumResultSize, requiresStartTime);
    }
}

