/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.sessionfetch;

import com.pushtechnology.diffusion.client.types.ErrorReport;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQueryResult;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.types.ErrorReportSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="session-fetch-query-result", valueType=SessionFetchQueryResult.class)
public final class SessionFetchQueryResultSerialiser
extends AbstractSerialiser<SessionFetchQueryResult> {
    private final ErrorReportSerialiser theErrorReportSerialiser;

    public SessionFetchQueryResultSerialiser(ErrorReportSerialiser errorReportSerialiser) {
        this.theErrorReportSerialiser = errorReportSerialiser;
    }

    @Override
    public void write(OutputStream out, SessionFetchQueryResult result) throws IOException {
        if (!result.hasErrors()) {
            EncodedDataCodec.writeByte(out, (byte)0);
            SessionFetchQueryResultSerialiser.writeCollection(out, SessionFetchQueryResultSerialiser::writeSessionInfo, result.sessions());
            EncodedDataCodec.writeInt32(out, result.totalSelected());
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            SessionFetchQueryResultSerialiser.writeCollection(out, this.theErrorReportSerialiser, result.errors());
        }
    }

    @Override
    protected SessionFetchQueryResult readUnchecked(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 0) {
            List<SessionFetchQueryResult.SessionInfo> sessions = SessionFetchQueryResultSerialiser.readList(in, SessionFetchQueryResultSerialiser::readSessionInfo);
            int totalSelected = EncodedDataCodec.readInt32(in);
            return new SessionFetchQueryResult(sessions, totalSelected);
        }
        List<ErrorReport> errors = SessionFetchQueryResultSerialiser.readList(in, this.theErrorReportSerialiser);
        return new SessionFetchQueryResult(errors);
    }

    private static SessionFetchQueryResult.SessionInfo readSessionInfo(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        Long startTime = option == 0 ? null : Long.valueOf(EncodedDataCodec.readInt64(in));
        Map<String, String> properties = SessionFetchQueryResultSerialiser.readStringMap(in);
        return new SessionFetchQueryResult.SessionInfo(startTime, properties);
    }

    private static void writeSessionInfo(OutputStream out, SessionFetchQueryResult.SessionInfo sessionInfo) throws IOException {
        Long startTime = sessionInfo.getStartTime();
        if (startTime == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeInt64(out, startTime);
        }
        SessionFetchQueryResultSerialiser.writeStringMap(out, sessionInfo.getProperties());
    }
}

