/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.sessionfetch;

import com.pushtechnology.diffusion.command.commands.sessionfetch.SessionFetchQueryResult;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class SessionFetchQuery {
    public static final Instant DEFAULT_FROM = Instant.MIN;
    public static final Instant DEFAULT_TO = Instant.MAX;
    private final String theFilter;
    private final Set<String> theRequestedProperties;
    private final Instant theFromInstant;
    private final Instant theToInstant;
    private final int theLimit;
    private final int theMaximumResultSize;
    private final boolean thisRequiresStartTime;

    public SessionFetchQuery(String filter, Set<String> requestedProperties, Instant from, Instant to, int limit, int maximumResultSize, boolean requiresStartTime) {
        this.theFilter = filter;
        this.theRequestedProperties = requestedProperties;
        this.theFromInstant = from;
        this.theToInstant = to;
        this.theLimit = limit;
        this.theMaximumResultSize = maximumResultSize;
        this.thisRequiresStartTime = requiresStartTime;
    }

    public String getFilter() {
        return this.theFilter;
    }

    public Set<String> getRequestedProperties() {
        return this.theRequestedProperties;
    }

    public Instant getFrom() {
        return this.theFromInstant;
    }

    public Instant getTo() {
        return this.theToInstant;
    }

    public int getLimit() {
        return this.theLimit;
    }

    public int getMaximumResultSize() {
        return this.theMaximumResultSize;
    }

    public boolean requiresStartTime() {
        return this.thisRequiresStartTime;
    }

    public SessionFetchQuery withStartTime() {
        if (this.thisRequiresStartTime) {
            return this;
        }
        return new SessionFetchQuery(this.theFilter, this.theRequestedProperties, this.theFromInstant, this.theToInstant, this.theLimit, this.theMaximumResultSize, true);
    }

    public SessionFetchQueryResult constrainedResult(List<SessionFetchQueryResult.SessionInfo> sessions, int totalSelected) {
        int number;
        int size = sessions.size();
        if (this.theLimit == 0) {
            return new SessionFetchQueryResult(Collections.emptyList(), totalSelected);
        }
        int n = number = this.theLimit > 0 ? this.theLimit : -this.theLimit;
        if (size <= number) {
            return new SessionFetchQueryResult(sessions, totalSelected);
        }
        if (this.theLimit > 0) {
            return new SessionFetchQueryResult(new ArrayList<SessionFetchQueryResult.SessionInfo>(sessions.subList(0, number)), totalSelected);
        }
        return new SessionFetchQueryResult(new ArrayList<SessionFetchQueryResult.SessionInfo>(sessions.subList(size - number, size)), totalSelected);
    }

    public int hashCode() {
        return Objects.hash(this.theFilter, this.theRequestedProperties, this.theFromInstant, this.theToInstant, this.theLimit, this.theMaximumResultSize, this.thisRequiresStartTime);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SessionFetchQuery)) {
            return false;
        }
        SessionFetchQuery other = (SessionFetchQuery)obj;
        return this.theFilter.equals(other.theFilter) && Objects.equals(this.theRequestedProperties, other.theRequestedProperties) && this.theFromInstant.equals(other.theFromInstant) && this.theToInstant.equals(other.theToInstant) && this.theLimit == other.theLimit && this.theMaximumResultSize == other.theMaximumResultSize && this.thisRequiresStartTime == other.thisRequiresStartTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("SessionFetchQuery [Filter=").append(this.theFilter).append(", Requested properties=").append(this.theRequestedProperties).append(", From=").append(this.theFromInstant).append(", To=").append(this.theToInstant).append(", Limit=").append(this.theLimit).append(", Max result size=").append(this.theMaximumResultSize).append(", Requires start time=").append(this.thisRequiresStartTime).append(']');
        return sb.toString();
    }
}

