/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.send;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.send.MessagingSendRequest;
import com.pushtechnology.diffusion.datatype.DataType;
import com.pushtechnology.diffusion.datatype.DataTypes;
import com.pushtechnology.diffusion.io.bytes.IBytes;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.TrailingBytesWriteSerialiser;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="messaging-send-request", valueType=MessagingSendRequest.class)
public final class MessagingSendRequestSerialiser
extends AbstractSerialiser<MessagingSendRequest>
implements TrailingBytesWriteSerialiser<MessagingSendRequest> {
    private final DataTypes dataTypes;

    public MessagingSendRequestSerialiser(DataTypes dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    protected MessagingSendRequest readUnchecked(InputStream in) throws IOException {
        String path = EncodedDataCodec.readString(in);
        DataType<?> dataType = this.dataTypes.getByName(EncodedDataCodec.readString(in));
        IBytes request = IBytes.toIBytes(EncodedDataCodec.readByteArray(in));
        return new MessagingSendRequest(path, dataType, request);
    }

    @Override
    public void writeHead(OutputStream out, MessagingSendRequest request) throws IOException {
        EncodedDataCodec.writeString(out, request.getPath());
        EncodedDataCodec.writeString(out, request.getDataType().getTypeName());
    }

    @Override
    public IBytes getTail(MessagingSendRequest request) {
        return request.getRequest();
    }
}

