/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.security;

import com.pushtechnology.diffusion.client.types.Credentials;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class ReauthenticateRequest
implements Journable {
    private final String thePrincipal;
    private final Credentials theCredentials;
    private final Map<String, String> theProposedSessionProperties;

    public ReauthenticateRequest(String principal, Credentials credentials, Map<String, String> proposedSessionProperties) {
        this.thePrincipal = principal;
        this.theCredentials = credentials;
        this.theProposedSessionProperties = Collections.unmodifiableMap(proposedSessionProperties);
    }

    public String getPrincipal() {
        return this.thePrincipal;
    }

    public Credentials getCredentials() {
        return this.theCredentials;
    }

    public Map<String, String> getProposedSessionProperties() {
        return this.theProposedSessionProperties;
    }

    public int hashCode() {
        return Objects.hash(this.thePrincipal, this.theCredentials, this.theProposedSessionProperties);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReauthenticateRequest)) {
            return false;
        }
        ReauthenticateRequest other = (ReauthenticateRequest)obj;
        return this.thePrincipal.equals(other.thePrincipal) && this.theCredentials.equals(other.theCredentials) && this.theProposedSessionProperties.equals(other.theProposedSessionProperties);
    }

    public String toString() {
        return "ReauthenticateRequest [Principal=" + this.thePrincipal + ", Credentials=" + String.valueOf(this.theCredentials) + ", ProposedSessionProperties=" + String.valueOf(this.theProposedSessionProperties) + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>(2);
        context.put("principal", this.thePrincipal);
        context.put("properties", this.theProposedSessionProperties);
        return context;
    }
}

