/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.security;

import com.pushtechnology.diffusion.client.types.GlobalPermission;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.security.GlobalPermissionsSet;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import com.pushtechnology.diffusion.security.common.RoleSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol16-global-permission-set", valueType=GlobalPermissionsSet.class)
public final class GlobalPermissionsSetSerialiser
extends AbstractSerialiser<GlobalPermissionsSet> {
    @Override
    protected GlobalPermissionsSet readUnchecked(InputStream in) throws IOException {
        return new GlobalPermissionsSet(GlobalPermissionsSetSerialiser.readCollection(in, x -> EnumSet.noneOf(GlobalPermission.class), GlobalPermissionsSetSerialiser::readPermission));
    }

    @Override
    public void write(OutputStream out, GlobalPermissionsSet value) throws IOException {
        GlobalPermissionsSetSerialiser.writeCollection(out, GlobalPermissionsSetSerialiser::writePermisssion, value.getPermissions());
    }

    private static GlobalPermission readPermission(InputStream in) throws IOException {
        return RoleSerialiser.PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER.fromByte(EncodedDataCodec.readByte(in));
    }

    private static void writePermisssion(OutputStream out, GlobalPermission permission) throws IOException {
        EncodedDataCodec.writeByte(out, RoleSerialiser.PROTOCOL_16_GLOBAL_PERMISSION_CONVERTER.toByte(permission));
    }
}

