/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway.services;

import com.pushtechnology.diffusion.command.commands.gateway.services.GatewayServiceDetail;
import com.pushtechnology.diffusion.command.commands.gateway.services.ServiceIdSerialiser;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
public final class ServiceDetailSerialiser
extends AbstractSerialiser<Gateway.ServiceDetail> {
    private final ServiceIdSerialiser theIdSerialiser;

    public ServiceDetailSerialiser(ServiceIdSerialiser idSerialiser) {
        this.theIdSerialiser = idSerialiser;
    }

    @Override
    public void write(OutputStream out, Gateway.ServiceDetail detail) throws IOException {
        this.theIdSerialiser.write(out, detail.getId());
        String description = detail.getDescription();
        if (description == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, description);
        }
        String configuration = detail.getConfiguration();
        if (configuration == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, configuration);
        }
    }

    @Override
    protected Gateway.ServiceDetail readUnchecked(InputStream in) throws IOException {
        Gateway.ServiceId serviceId = (Gateway.ServiceId)this.theIdSerialiser.read(in);
        byte descOption = EncodedDataCodec.readByte(in);
        String description = descOption == 0 ? null : EncodedDataCodec.readString(in);
        byte confOption = EncodedDataCodec.readByte(in);
        String configuration = confOption == 0 ? null : EncodedDataCodec.readString(in);
        return new GatewayServiceDetail(serviceId, description, configuration);
    }
}

