/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.ConfigurationModeConvertor;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKeySerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayValidationRequest;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-validation-request", valueType=GatewayValidationRequest.class)
public final class GatewayValidationRequestSerialiser
extends AbstractSerialiser<GatewayValidationRequest> {
    private final GatewayClientKeySerialiser theClientKeySerialiser;

    public GatewayValidationRequestSerialiser(GatewayClientKeySerialiser clientKeySerialiser) {
        this.theClientKeySerialiser = clientKeySerialiser;
    }

    @Override
    public void write(OutputStream out, GatewayValidationRequest request) throws IOException {
        this.theClientKeySerialiser.write(out, request.getClientKey());
        EncodedDataCodec.writeByte(out, ConfigurationModeConvertor.toByte(request.getConfigurationMode()));
        EncodedDataCodec.writeByteArray(out, request.getHash());
    }

    @Override
    protected GatewayValidationRequest readUnchecked(InputStream in) throws IOException {
        return new GatewayValidationRequest((GatewayClientKey)this.theClientKeySerialiser.read(in), ConfigurationModeConvertor.fromByte(EncodedDataCodec.readByte(in)), EncodedDataCodec.readByteArray(in));
    }
}

