/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.journal.Journable;
import com.pushtechnology.diffusion.utils.string.StringUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayValidationRequest
implements Journable {
    private final GatewayClientKey theClientKey;
    private final Gateway.ConfigurationMode theConfigurationMode;
    private final byte[] theHash;

    public GatewayValidationRequest(GatewayClientKey clientKey, Gateway.ConfigurationMode configurationMode, byte[] hash) {
        this.theClientKey = clientKey;
        this.theConfigurationMode = configurationMode;
        this.theHash = hash;
    }

    public GatewayClientKey getClientKey() {
        return this.theClientKey;
    }

    public Gateway.ConfigurationMode getConfigurationMode() {
        return this.theConfigurationMode;
    }

    public byte[] getHash() {
        return this.theHash;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.theClientKey, this.theConfigurationMode, this.theHash});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GatewayValidationRequest)) {
            return false;
        }
        GatewayValidationRequest other = (GatewayValidationRequest)obj;
        return this.theClientKey.equals(other.theClientKey) && this.theConfigurationMode == other.theConfigurationMode && Arrays.equals(this.theHash, other.theHash);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GatewayValidationRequest [ClientKey=" + String.valueOf(this.theClientKey) + ", ConfigurationMode=" + String.valueOf((Object)this.theConfigurationMode) + ", Hash=");
        StringUtils.appendHex(sb, this.theHash, 0, this.theHash.length);
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Map<String, Object> getJournableContext() {
        Map<String, Object> context = this.theClientKey.getJournableContext();
        context.put("mode", (Object)this.theConfigurationMode);
        return context;
    }
}

