/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequest;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRequestType;
import com.pushtechnology.diffusion.command.commands.gateway.configuration.GetConfigurationRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GetOperationDetailRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.operations.GetOperationsRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.operations.InvokeOperationRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.AddServiceRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceConfigurationRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceOperationDetailRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceOperationsRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceStatusRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServiceTypesRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.GetServicesRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.InvokeServiceOperationRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.RemoveServiceRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.ServiceDetailSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.ServiceIdSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.services.UpdateServiceRequestSubSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.status.GetStatusRequestSubSerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-request", valueType=GatewayRequest.class)
public final class GatewayRequestSerialiser
extends AbstractSerialiser<GatewayRequest> {
    private final Map<GatewayRequestType, GatewayRequestSubSerialiser> theSubSerialisers = new HashMap<GatewayRequestType, GatewayRequestSubSerialiser>();

    public GatewayRequestSerialiser() {
        ServiceIdSerialiser serviceIdSerialiser = new ServiceIdSerialiser();
        ServiceDetailSerialiser serviceDetailSerialiser = new ServiceDetailSerialiser(serviceIdSerialiser);
        this.theSubSerialisers.put(GatewayRequestType.GET_CONFIGURATION, new GetConfigurationRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.GET_STATUS, new GetStatusRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.GET_OPERATIONS, new GetOperationsRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.GET_OPERATION_DETAIL, new GetOperationDetailRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.INVOKE_OPERATION, new InvokeOperationRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.ADD_SERVICE, new AddServiceRequestSubSerialiser(serviceDetailSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.UPDATE_SERVICE, new UpdateServiceRequestSubSerialiser(serviceDetailSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.REMOVE_SERVICE, new RemoveServiceRequestSubSerialiser(serviceIdSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICES, new GetServicesRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICE_TYPES, new GetServiceTypesRequestSubSerialiser());
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICE_CONFIGURATION, new GetServiceConfigurationRequestSubSerialiser(serviceIdSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICE_STATUS, new GetServiceStatusRequestSubSerialiser(serviceIdSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICE_OPERATIONS, new GetServiceOperationsRequestSubSerialiser(serviceIdSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.GET_SERVICE_OPERATION_DETAIL, new GetServiceOperationDetailRequestSubSerialiser(serviceIdSerialiser));
        this.theSubSerialisers.put(GatewayRequestType.INVOKE_SERVICE_OPERATION, new InvokeServiceOperationRequestSubSerialiser(serviceIdSerialiser));
    }

    @Override
    public void write(OutputStream out, GatewayRequest request) throws IOException {
        GatewayRequestType type = request.getType();
        EncodedDataCodec.writeByte(out, type.toByte());
        this.theSubSerialisers.get((Object)type).completeWrite(out, request);
    }

    @Override
    public GatewayRequest readUnchecked(InputStream in) throws IOException {
        GatewayRequestType type = GatewayRequestType.fromByte(EncodedDataCodec.readByte(in));
        return this.theSubSerialisers.get((Object)type).completeRead(in);
    }
}

