/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClient;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayRegistrationResponse;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-registration-response", valueType=GatewayRegistrationResponse.class)
public final class GatewayRegistrationResponseSerialiser
extends AbstractSerialiser<GatewayRegistrationResponse> {
    private static final EnumConverter<Gateway.GatewayRegistrationException.ErrorCode> CONVERTER = new EnumConverter.Builder<Gateway.GatewayRegistrationException.ErrorCode>(Gateway.GatewayRegistrationException.ErrorCode.class).bimap(1, Gateway.GatewayRegistrationException.ErrorCode.DUPLICATE_CLIENT_REGISTRATION).build();
    private final GatewayClientSerialiser theClientSerialiser;

    public GatewayRegistrationResponseSerialiser(GatewayClientSerialiser clientSerialiser) {
        this.theClientSerialiser = clientSerialiser;
    }

    @Override
    public void write(OutputStream out, GatewayRegistrationResponse response) throws IOException {
        GatewayClient client = response.getGatewayClient();
        if (client != null) {
            EncodedDataCodec.writeByte(out, (byte)0);
            this.theClientSerialiser.write(out, response.getGatewayClient());
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeByte(out, CONVERTER.toByte(response.getErrorCode()));
        }
    }

    @Override
    protected GatewayRegistrationResponse readUnchecked(InputStream in) throws IOException {
        byte option = EncodedDataCodec.readByte(in);
        if (option == 0) {
            return new GatewayRegistrationResponse((GatewayClient)this.theClientSerialiser.read(in));
        }
        if (option == 1) {
            return new GatewayRegistrationResponse(CONVERTER.fromByte(EncodedDataCodec.readByte(in)));
        }
        throw new IOException("Invalid option " + option);
    }
}

