/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.commands.gateway.ConfigurationModeConvertor;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayConnectedClientDetails;
import com.pushtechnology.diffusion.gateway.Gateway;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import net.jcip.annotations.Immutable;

@Immutable
final class GatewayConnectedClientDetailsSerialiser
extends AbstractSerialiser<GatewayConnectedClientDetails> {
    GatewayConnectedClientDetailsSerialiser() {
    }

    @Override
    public void write(OutputStream out, GatewayConnectedClientDetails connectedClientDetails) throws IOException {
        String activeSessionId = connectedClientDetails.getActiveSessionId();
        if (activeSessionId == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeString(out, activeSessionId);
        }
        GatewayConnectedClientDetailsSerialiser.writeStrings(out, connectedClientDetails.getPassiveSessionIds());
        Gateway.ConfigurationMode configurationMode = connectedClientDetails.getConfigurationMode();
        if (configurationMode == null) {
            EncodedDataCodec.writeByte(out, (byte)0);
        } else {
            EncodedDataCodec.writeByte(out, (byte)1);
            EncodedDataCodec.writeByte(out, ConfigurationModeConvertor.toByte(configurationMode));
        }
    }

    @Override
    protected GatewayConnectedClientDetails readUnchecked(InputStream in) throws IOException {
        Gateway.ConfigurationMode configurationMode;
        String activeSessionId;
        byte activeSessionIdOption = EncodedDataCodec.readByte(in);
        if (activeSessionIdOption == 0) {
            activeSessionId = null;
        } else if (activeSessionIdOption == 1) {
            activeSessionId = EncodedDataCodec.readString(in);
        } else {
            throw new IOException("Invalid active sessionId option " + activeSessionIdOption);
        }
        HashSet<String> passiveSessionIds = new HashSet<String>(GatewayConnectedClientDetailsSerialiser.readStrings(in));
        byte modeOption = EncodedDataCodec.readByte(in);
        if (modeOption == 0) {
            configurationMode = null;
        } else if (modeOption == 1) {
            configurationMode = ConfigurationModeConvertor.fromByte(EncodedDataCodec.readByte(in));
        } else {
            throw new IOException("Invalid configuration mode option " + modeOption);
        }
        return new GatewayConnectedClientDetails(activeSessionId, passiveSessionIds, configurationMode);
    }
}

