/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClient;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKeySerialiser;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import com.pushtechnology.diffusion.io.serialisation.impl.AbstractSerialiser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="gateway-client", valueType=GatewayClient.class)
public final class GatewayClientSerialiser
extends AbstractSerialiser<GatewayClient> {
    private final GatewayClientKeySerialiser theKeySerialiser;

    public GatewayClientSerialiser(GatewayClientKeySerialiser keySerialiser) {
        this.theKeySerialiser = keySerialiser;
    }

    @Override
    public void write(OutputStream out, GatewayClient client) throws IOException {
        this.theKeySerialiser.write(out, client.getKey());
        EncodedDataCodec.writeByte(out, (byte)1);
        EncodedDataCodec.writeString(out, client.getSchema());
        EncodedDataCodec.writeString(out, client.getConfiguration());
    }

    @Override
    protected GatewayClient readUnchecked(InputStream in) throws IOException {
        GatewayClientKey key = (GatewayClientKey)this.theKeySerialiser.read(in);
        EncodedDataCodec.readByte(in);
        String schema = EncodedDataCodec.readString(in);
        String configuration = EncodedDataCodec.readString(in);
        return new GatewayClient(key, schema, configuration);
    }
}

