/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.gateway;

import com.pushtechnology.diffusion.command.commands.gateway.GatewayClientKey;
import com.pushtechnology.diffusion.journal.Journable;
import java.util.Map;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class GatewayClient
implements Journable {
    private final GatewayClientKey theKey;
    private final String theSchema;
    private final String theConfiguration;

    public GatewayClient(GatewayClientKey key, String schema, String configuration) {
        this.theKey = key;
        this.theSchema = schema;
        this.theConfiguration = configuration;
    }

    public GatewayClientKey getKey() {
        return this.theKey;
    }

    public String getSchema() {
        return this.theSchema;
    }

    public String getConfiguration() {
        return this.theConfiguration;
    }

    public boolean isConfigured() {
        return !this.theSchema.isEmpty() || !this.theConfiguration.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.theKey, this.theSchema, this.theConfiguration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GatewayClient)) {
            return false;
        }
        GatewayClient other = (GatewayClient)obj;
        return this.theKey.equals(other.theKey) && this.theSchema.equals(other.theSchema) && this.theConfiguration.equals(other.theConfiguration);
    }

    public String toString() {
        return "GatewayClient [Type=" + this.theKey.getType() + ", Id=" + this.theKey.getId() + "]";
    }

    @Override
    public Map<String, Object> getJournableContext() {
        return this.theKey.getJournableContext();
    }
}

