/*
 * Decompiled with CFR 0.152.
 */
package com.pushtechnology.diffusion.command.commands.fetch;

import com.pushtechnology.diffusion.client.types.serialisation.EnumConverter;
import com.pushtechnology.diffusion.command.annotations.CommandSerialiser;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicResult;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicResultSerialiser;
import com.pushtechnology.diffusion.command.commands.fetch.FetchTopicSizeInfo;
import com.pushtechnology.diffusion.command.commands.fetch.SimpleTopicSizeInfo;
import com.pushtechnology.diffusion.command.commands.fetch.TimeSeriesSizeInfo;
import com.pushtechnology.diffusion.io.encoding.EncodedDataCodec;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.Immutable;

@Immutable
@CommandSerialiser(spec="protocol28-fetch-topic-result", valueType=FetchTopicResult.class)
public final class Protocol28FetchTopicResultSerialiser
extends FetchTopicResultSerialiser {
    private static final EnumConverter<FetchTopicSizeInfo.SizeType> CONVERTER = new EnumConverter.Builder<FetchTopicSizeInfo.SizeType>(FetchTopicSizeInfo.SizeType.class).bimap(0, FetchTopicSizeInfo.SizeType.NO_SIZE_INFO).bimap(1, FetchTopicSizeInfo.SizeType.SIMPLE_SIZE_INFO).bimap(2, FetchTopicSizeInfo.SizeType.TIME_SERIES_SIZE_INFO).build();

    @Override
    public void write(OutputStream out, FetchTopicResult result) throws IOException {
        super.write(out, result);
        FetchTopicSizeInfo sizeInfo = result.sizeInfo();
        FetchTopicSizeInfo.SizeType infoType = sizeInfo.getInfoType();
        EncodedDataCodec.writeByte(out, CONVERTER.toByte(infoType));
        if (infoType == FetchTopicSizeInfo.SizeType.SIMPLE_SIZE_INFO) {
            EncodedDataCodec.writeInt32(out, sizeInfo.valueSize());
        } else if (infoType == FetchTopicSizeInfo.SizeType.TIME_SERIES_SIZE_INFO) {
            EncodedDataCodec.writeInt32(out, sizeInfo.valueSize());
            EncodedDataCodec.writeInt32(out, sizeInfo.valueCount());
            EncodedDataCodec.writeInt64(out, sizeInfo.valueTotalSize());
        }
    }

    @Override
    public FetchTopicResult readUnchecked(InputStream in) throws IOException {
        return new FetchTopicResult(this.readPath(in), this.readType(in), this.readValue(in), this.readPropertiesIndex(in), this.readSizeInfo(in));
    }

    private FetchTopicSizeInfo readSizeInfo(InputStream in) throws IOException {
        FetchTopicSizeInfo.SizeType infoType = CONVERTER.fromByte(EncodedDataCodec.readByte(in));
        FetchTopicSizeInfo topicSizeInfo = infoType == FetchTopicSizeInfo.SizeType.SIMPLE_SIZE_INFO ? new SimpleTopicSizeInfo(EncodedDataCodec.readInt32(in)) : (infoType == FetchTopicSizeInfo.SizeType.TIME_SERIES_SIZE_INFO ? new TimeSeriesSizeInfo(EncodedDataCodec.readInt32(in), EncodedDataCodec.readInt32(in), EncodedDataCodec.readInt64(in)) : FetchTopicSizeInfo.NO_TOPIC_SIZE_INFO);
        return topicSizeInfo;
    }
}

